/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.gui.inv.SeparateInvImpl;
import io.github.flemmli97.flan.gui.inv.SlotDelegate;
import io.github.flemmli97.flan.mixin.AbstractContainerAccessor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class ServerOnlyScreenHandler<T>
extends AbstractContainerMenu {
    protected final SeparateInvImpl inventory;
    protected final ServerPlayer player;
    protected final T data;

    protected ServerOnlyScreenHandler(int syncId, Inventory playerInventory, int rows, T additionalData) {
        super(ServerOnlyScreenHandler.fromRows(rows), syncId);
        int m;
        int n;
        int i = (rows - 4) * 18;
        this.inventory = new SeparateInvImpl(rows * 9);
        Player player = playerInventory.f_35978_;
        if (!(player instanceof ServerPlayer)) {
            throw new IllegalStateException("This is a server only menu!");
        }
        ServerPlayer p = (ServerPlayer)player;
        this.player = p;
        this.data = additionalData;
        for (n = 0; n < rows; ++n) {
            for (m = 0; m < 9; ++m) {
                this.m_38897_(new SlotDelegate(this.inventory, m + n * 9, 8 + m * 18, 18 + n * 18));
            }
        }
        for (n = 0; n < 3; ++n) {
            for (m = 0; m < 9; ++m) {
                this.m_38897_(new Slot((Container)playerInventory, m + n * 9 + 9, 8 + m * 18, 103 + n * 18 + i){

                    public boolean m_5857_(ItemStack stack) {
                        return false;
                    }

                    public boolean m_8010_(Player playerEntity) {
                        return false;
                    }
                });
            }
        }
        for (n = 0; n < 9; ++n) {
            this.m_38897_(new Slot((Container)playerInventory, n, 8 + n * 18, 161 + i){

                public boolean m_5857_(ItemStack stack) {
                    return false;
                }

                public boolean m_8010_(Player playerEntity) {
                    return false;
                }
            });
        }
        this.setupGui();
    }

    private static MenuType<ChestMenu> fromRows(int rows) {
        return switch (rows) {
            case 2 -> MenuType.f_39958_;
            case 3 -> MenuType.f_39959_;
            case 4 -> MenuType.f_39960_;
            case 5 -> MenuType.f_39961_;
            case 6 -> MenuType.f_39962_;
            default -> MenuType.f_39957_;
        };
    }

    protected void setupGui() {
        this.fillInventoryWith();
    }

    protected abstract void fillInventoryWith();

    public boolean m_6875_(Player player) {
        return true;
    }

    public void m_150399_(int i, int j, ClickType clickType, Player player) {
        if (i < 0) {
            return;
        }
        Slot slot = (Slot)this.f_38839_.get(i);
        if (clickType != ClickType.PICKUP_ALL && this.isRightSlot(i)) {
            if (((AbstractContainerAccessor)((Object)this)).containerSync() != null) {
                ((AbstractContainerAccessor)((Object)this)).containerSync().m_142529_((AbstractContainerMenu)this, this.m_142621_().m_41777_());
            }
            this.handleSlotClicked((ServerPlayer)player, i, slot, j);
        }
        ItemStack stack = slot.m_7993_().m_41777_();
        for (ContainerListener listener : ((AbstractContainerAccessor)((Object)this)).listeners()) {
            listener.m_7934_((AbstractContainerMenu)this, i, stack);
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        if (index < 0) {
            return ItemStack.f_41583_;
        }
        Slot slot = (Slot)this.f_38839_.get(index);
        if (this.isRightSlot(index)) {
            this.handleSlotClicked((ServerPlayer)player, index, slot, 0);
        }
        return slot.m_7993_().m_41777_();
    }

    protected abstract boolean isRightSlot(int var1);

    protected abstract boolean handleSlotClicked(ServerPlayer var1, int var2, Slot var3, int var4);
}

