/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.config.Config;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.linguabib.api.LanguageAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ServerScreenHelper {
    public static final String PERMISSION_KEY = "flan.permission";

    public static ItemStack emptyFiller() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42183_);
        stack.m_41714_((Component)ClaimUtils.translatedText("", new Object[0]));
        return stack;
    }

    public static ItemStack fromPermission(Claim claim, ServerPlayer player, ClaimPermission perm, String group) {
        ItemStack stack = perm.getItem();
        stack.m_41714_((Component)ServerScreenHelper.coloredGuiText(perm.translationKey(), ChatFormatting.GOLD));
        ArrayList<Component> lore = new ArrayList<Component>();
        for (String pdesc : LanguageAPI.getFormattedKeys((ServerPlayer)player, (String)perm.translationKeyDescription())) {
            MutableComponent trans = ServerScreenHelper.coloredGuiText(pdesc, ChatFormatting.YELLOW);
            lore.add((Component)trans);
        }
        Config.GlobalType global = ConfigHandler.CONFIG.getGlobal(claim.getLevel(), perm.getId());
        if (!claim.isAdminClaim() && !global.canModify()) {
            MutableComponent text = ServerScreenHelper.coloredGuiText("flan.screenUneditable", ChatFormatting.DARK_RED);
            lore.add((Component)text);
            String permFlag = global.getValue() ? "flan.screenTrue" : "flan.screenFalse";
            MutableComponent text2 = ServerScreenHelper.coloredGuiText("flan.screenEnableText", ServerScreenHelper.coloredGuiText(permFlag, new Object[0]), permFlag.equals("flan.screenTrue") ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add((Component)text2);
        } else {
            String permFlag;
            if (group == null) {
                if (claim.parentClaim() == null) {
                    permFlag = claim.permEnabled(perm.getId()) == 1 ? "flan.screenTrue" : "flan.screenFalse";
                } else {
                    permFlag = switch (claim.permEnabled(perm.getId())) {
                        case -1 -> "flan.screenDefault";
                        case 1 -> "flan.screenTrue";
                        default -> "flan.screenFalse";
                    };
                }
            } else {
                permFlag = switch (claim.groupHasPerm(group, perm.getId())) {
                    case -1 -> "flan.screenDefault";
                    case 1 -> "flan.screenTrue";
                    default -> "flan.screenFalse";
                };
            }
            MutableComponent text = ServerScreenHelper.coloredGuiText("flan.screenEnableText", ServerScreenHelper.coloredGuiText(permFlag, new Object[0]), permFlag.equals("flan.screenTrue") ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add((Component)text);
        }
        ServerScreenHelper.addLore(stack, lore);
        CompoundTag tag = stack.m_41783_();
        tag.m_128359_(PERMISSION_KEY, perm.getId().toString());
        return stack;
    }

    public static ItemStack getFromPersonal(ServerPlayer player, ClaimPermission perm, String group) {
        ItemStack stack = perm.getItem();
        stack.m_41714_((Component)ServerScreenHelper.coloredGuiText(perm.translationKey(), ChatFormatting.GOLD));
        ListTag lore = new ListTag();
        for (String pdesc : LanguageAPI.getFormattedKeys((ServerPlayer)player, (String)perm.translationKeyDescription())) {
            MutableComponent trans = ServerScreenHelper.coloredGuiText(pdesc, ChatFormatting.YELLOW);
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)trans)));
        }
        Config.GlobalType global = ConfigHandler.CONFIG.getGlobal(player.m_284548_(), perm.getId());
        if (!global.canModify()) {
            MutableComponent text = ServerScreenHelper.coloredGuiText("flan.screenUneditable", ChatFormatting.DARK_RED);
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text)));
            boolean permFlag = global.getValue();
            MutableComponent text2 = ServerScreenHelper.coloredGuiText("flan.screenEnableText", ServerScreenHelper.coloredGuiText(permFlag ? "flan.screenTrue" : "flan.screenFalse", new Object[0]), permFlag ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text2)));
        } else {
            Map map = PlayerClaimData.get(player).playerDefaultGroups().getOrDefault(group, new HashMap());
            String permFlag = map.containsKey(perm.getId()) ? ((Boolean)map.get(perm.getId()) != false ? "flan.screenTrue" : "flan.screenFalse") : "flan.screenDefault";
            MutableComponent text = ServerScreenHelper.coloredGuiText("flan.screenEnableText", ServerScreenHelper.coloredGuiText(permFlag, new Object[0]), permFlag.equals("flan.screenTrue") ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text)));
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(PERMISSION_KEY, perm.getId().toString());
        CompoundTag display = tag.m_128441_("display") ? tag.m_128469_("display") : new CompoundTag();
        display.m_128365_("Lore", (Tag)lore);
        return stack;
    }

    public static void playSongToPlayer(ServerPlayer player, SoundEvent event, float vol, float pitch) {
        player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)event), SoundSource.PLAYERS, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, vol, pitch, player.m_9236_().m_213780_().m_188505_()));
    }

    public static void playSongToPlayer(ServerPlayer player, Holder<SoundEvent> event, float vol, float pitch) {
        player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(event, SoundSource.PLAYERS, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, vol, pitch, player.m_9236_().m_213780_().m_188505_()));
    }

    public static MutableComponent coloredGuiText(String key, Object ... compArgs) {
        ArrayList<ChatFormatting> formattings = new ArrayList<ChatFormatting>();
        ArrayList<Object> args = new ArrayList<Object>();
        for (Object obj : compArgs) {
            if (obj instanceof ChatFormatting) {
                ChatFormatting formatting = (ChatFormatting)obj;
                formattings.add(formatting);
                continue;
            }
            args.add(obj);
        }
        return Component.m_237110_((String)key, (Object[])args.toArray()).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_131152_((ChatFormatting[])formattings.toArray(ChatFormatting[]::new)));
    }

    public static void addLore(ItemStack stack, Component text) {
        ListTag lore = new ListTag();
        lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text)));
        stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
    }

    public static void addLore(ItemStack stack, List<Component> texts) {
        ListTag lore = new ListTag();
        texts.forEach(text -> lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text))));
        stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
    }
}

