/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.mixin;

import io.github.flemmli97.flan.event.PlayerEvents;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.utils.IOwnedItem;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
implements IOwnedItem {
    @Unique
    private UUID flanPlayerOrigin;
    @Unique
    private UUID flanDeathPlayerOrigin;

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void readData(CompoundTag tag, CallbackInfo info) {
        if (tag.m_128441_("Flan:PlayerOrigin")) {
            this.flanPlayerOrigin = tag.m_128342_("Flan:PlayerOrigin");
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void writeData(CompoundTag tag, CallbackInfo info) {
        if (this.flanPlayerOrigin != null) {
            tag.m_128362_("Flan:PlayerOrigin", this.flanPlayerOrigin);
        }
    }

    @Override
    public void setOriginPlayer(Player player) {
        this.flanPlayerOrigin = player.m_20148_();
        if (player instanceof ServerPlayer && PlayerClaimData.get((ServerPlayer)player).setDeathItemOwner()) {
            this.flanDeathPlayerOrigin = this.flanPlayerOrigin;
        }
    }

    @Inject(method={"playerTouch"}, at={@At(value="HEAD")}, cancellable=true)
    private void pickup(Player player, CallbackInfo info) {
        if (!PlayerEvents.canCollideWith(player, (Entity)((ItemEntity)this))) {
            info.cancel();
        }
    }

    @Override
    public UUID getDeathPlayer() {
        return this.flanDeathPlayerOrigin;
    }

    @Override
    public UUID getPlayerOrigin() {
        return this.flanPlayerOrigin;
    }
}

