/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.platform.integration.currency;

import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.math.BigDecimal;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.impactdev.impactor.api.economy.EconomyService;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class CommonCurrency {
    public static int sell(ServerPlayer player, int blocks, float value, Consumer<Component> message) {
        if (Flan.impactor) {
            PlayerClaimData data = PlayerClaimData.get(player);
            if (data.getAdditionalClaims() - Math.max(0, data.usedClaimBlocks() - data.getClaimBlocks()) < blocks) {
                message.accept((Component)ClaimUtils.translatedText("flan.sellFail", ChatFormatting.DARK_RED));
                return 0;
            }
            CompletableFuture future = EconomyService.instance().account(player.m_20148_());
            future.thenAcceptAsync(acc -> {
                BigDecimal price = BigDecimal.valueOf((float)blocks * value);
                acc.depositAsync(price);
                data.setAdditionalClaims(data.getAdditionalClaims() - blocks);
                message.accept((Component)ClaimUtils.translatedText("flan.sellSuccess", blocks, price, ChatFormatting.GOLD));
            });
            return 1;
        }
        return -1;
    }

    public static int buy(ServerPlayer player, int blocks, float value, Consumer<Component> message) {
        if (Flan.impactor) {
            CompletableFuture future = EconomyService.instance().account(player.m_20148_());
            return (Integer)((CompletableFuture)future.thenApplyAsync(acc -> {
                BigDecimal price;
                @NotNull BigDecimal bal = (BigDecimal)acc.balanceAsync().join();
                if (bal.compareTo(price = BigDecimal.valueOf((float)blocks * value)) >= 0) {
                    acc.withdrawAsync(price);
                    PlayerClaimData data = PlayerClaimData.get(player);
                    data.setAdditionalClaims(data.getAdditionalClaims() + blocks);
                    message.accept((Component)ClaimUtils.translatedText("flan.buySuccess", blocks, price, ChatFormatting.GOLD));
                    return 1;
                }
                return 0;
            })).join();
        }
        return -1;
    }
}

