/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.platform.integration.webmap;

import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimBox;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.platform.integration.webmap.WebmapCalls;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;

public class DynmapIntegration {
    private static MarkerSet markerSet;
    private static final String MARKER_ID = "flan.claims";
    private static final String MARKER_LABEL = "Claims";

    public static void reg() {
        DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

            public void apiEnabled(DynmapCommonAPI dynmapCommonAPI) {
                MarkerAPI markerAPI = dynmapCommonAPI.getMarkerAPI();
                markerSet = markerAPI.createMarkerSet(DynmapIntegration.MARKER_ID, DynmapIntegration.MARKER_LABEL, dynmapCommonAPI.getMarkerAPI().getMarkerIcons(), false);
                WebmapCalls.dynmapLoaded = true;
            }
        });
    }

    static void addClaimMarker(Claim claim) {
        if (markerSet == null) {
            return;
        }
        ClaimBox dim = claim.getDimensions();
        AreaMarker marker = markerSet.createAreaMarker(claim.getClaimID().toString(), DynmapIntegration.claimLabel(claim), true, DynmapIntegration.getWorldName((Level)claim.getLevel()), new double[]{dim.minX(), dim.maxX()}, new double[]{dim.minZ(), dim.maxZ()}, false);
        if (marker != null) {
            marker.setLineStyle(3, 0.8, DynmapIntegration.lineColor(claim.isAdminClaim()));
            marker.setFillStyle(0.2, DynmapIntegration.fillColor(claim.isAdminClaim()));
            marker.setRangeY((double)dim.minY(), (double)dim.maxY());
        }
    }

    static void removeMarker(Claim claim) {
        if (markerSet == null) {
            return;
        }
        AreaMarker marker = markerSet.findAreaMarker(claim.getClaimID().toString());
        if (marker != null) {
            marker.deleteMarker();
        }
    }

    static void changeClaimName(Claim claim) {
        if (markerSet == null) {
            return;
        }
        AreaMarker marker = markerSet.findAreaMarker(claim.getClaimID().toString());
        if (marker != null) {
            marker.setLabel(DynmapIntegration.claimLabel(claim));
        }
    }

    static void changeClaimOwner(Claim claim) {
        AreaMarker marker;
        if (markerSet == null) {
            return;
        }
        if ((claim.getClaimName() == null || claim.getClaimName().isEmpty()) && (marker = markerSet.findAreaMarker(claim.getClaimID().toString())) != null) {
            marker.setLabel(DynmapIntegration.claimLabel(claim));
        }
    }

    private static String getWorldName(Level level) {
        ResourceKey key = level.m_46472_();
        if (key == Level.f_46428_) {
            return level.m_7654_().m_129910_().m_5462_();
        }
        if (key == Level.f_46430_) {
            return "DIM1";
        }
        if (key == Level.f_46429_) {
            return "DIM-1";
        }
        return key.m_135782_().m_135827_() + "_" + key.m_135782_().m_135815_();
    }

    private static int lineColor(boolean admin) {
        return admin ? 11864329 : 16753152;
    }

    private static int fillColor(boolean admin) {
        return admin ? 0xFF0000 : 14737437;
    }

    private static String claimLabel(Claim claim) {
        String name = claim.getClaimName();
        if (name == null || name.isEmpty()) {
            if (claim.isAdminClaim()) {
                return "Admin Claim";
            }
            Optional<String> prof = ClaimUtils.fetchUsername(claim.getOwner(), claim.getLevel().m_7654_());
            return prof.orElse("UNKOWN") + "'s Claim";
        }
        return name;
    }
}

