/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.player;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;

public class ClientBlockDisplayTracker {
    private final Map<UUID, Set<DisplayData>> fakeBlocks = new HashMap<UUID, Set<DisplayData>>();
    private final Map<BlockPos, List<UUID>> lookup = new HashMap<BlockPos, List<UUID>>();
    private final ServerPlayer player;

    public ClientBlockDisplayTracker(ServerPlayer player) {
        this.player = player;
    }

    public void displayFakeBlocks(UUID id, DisplayData ... blocks) {
        HashSet<DisplayData> newData = new HashSet<DisplayData>(List.of(blocks));
        this.displayFakeBlocks(id, newData);
    }

    public void displayFakeBlocks(UUID id, Set<DisplayData> blocks) {
        Sets.SetView diff;
        Set<DisplayData> current = this.fakeBlocks.get(id);
        if (current != null && !(diff = Sets.difference(current, blocks)).isEmpty()) {
            this.resetBlocks(id, (Set<DisplayData>)diff);
        }
        for (DisplayData data : blocks) {
            this.player.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket(data.pos, data.state));
            this.lookup.computeIfAbsent(data.pos, k -> new ArrayList()).add(id);
        }
        this.fakeBlocks.put(id, blocks);
    }

    public void resetFakeBlocks(UUID id) {
        Set<DisplayData> current = this.fakeBlocks.remove(id);
        if (current != null) {
            this.resetBlocks(id, current);
        }
    }

    private void resetBlocks(UUID id, Set<DisplayData> blocks) {
        blocks.forEach(d -> {
            List<UUID> stateLookup = this.lookup.get(d.pos);
            BlockState state = null;
            if (stateLookup != null) {
                Set<DisplayData> others;
                stateLookup.removeIf(i -> i.equals(id));
                if (!stateLookup.isEmpty() && (others = this.fakeBlocks.get(stateLookup.get(stateLookup.size() - 1))) != null) {
                    for (DisplayData o : others) {
                        if (!o.pos.equals((Object)d.pos)) continue;
                        state = o.state;
                        break;
                    }
                }
                if (stateLookup.isEmpty()) {
                    this.lookup.remove(d.pos);
                }
            }
            this.player.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket(d.pos, state == null ? this.player.m_9236_().m_8055_(d.pos) : state));
        });
    }

    public record DisplayData(BlockPos pos, BlockState state) {
        @Override
        public int hashCode() {
            return this.pos.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DisplayData)) {
                return false;
            }
            DisplayData data = (DisplayData)obj;
            return this.pos.equals((Object)data.pos);
        }
    }
}

