/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.player.display;

import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimBox;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.player.ClientBlockDisplayTracker;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.DisplayBox;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;

public class ClaimDisplay {
    private int displayTime;
    private final int displayHeight;
    private final DisplayBox display;
    public final EnumDisplayType type;
    private DisplayBoxPos pos;
    private ClaimBox prevDims;

    public ClaimDisplay(Claim claim, EnumDisplayType type, int y) {
        this(claim.display(), (Level)claim.getLevel(), type, y);
    }

    public ClaimDisplay(DisplayBox display, Level level, EnumDisplayType type, int y) {
        this.display = display;
        this.displayTime = ConfigHandler.CONFIG.claimDisplayTime;
        this.type = type;
        this.displayHeight = Math.max(1 + level.m_141937_(), y);
    }

    private static DisplayBoxPos calculatePos(ServerLevel level, DisplayBox display, int height) {
        boolean is3d = display.is3d();
        ChunkCache chunkCache = new ChunkCache(level);
        ClaimBox box = display.box();
        List<BlockPos> vertices = ClaimDisplay.boxVertices(box, is3d);
        List<BlockPos> edges = ClaimDisplay.boxEdges(box, display.excludedSides(), is3d, height, vertices, chunkCache);
        if (!is3d) {
            ArrayList<BlockPos> verticesNew = new ArrayList<BlockPos>();
            for (BlockPos pos : vertices) {
                Height heightPos = ClaimDisplay.getHeight(pos.m_123341_(), pos.m_123343_(), height, chunkCache);
                if (heightPos == null) continue;
                if (heightPos.solid != heightPos.water) {
                    verticesNew.add(new BlockPos(box.minX(), heightPos.water, box.minZ()));
                }
                verticesNew.add(new BlockPos(box.minX(), heightPos.solid, box.minZ()));
            }
            vertices = verticesNew;
        }
        return new DisplayBoxPos(vertices, edges);
    }

    private static List<BlockPos> boxVertices(ClaimBox box, boolean is3d) {
        ArrayList<BlockPos> vertices = new ArrayList<BlockPos>();
        if (is3d) {
            vertices.add(new BlockPos(box.minX(), box.minY(), box.minZ()));
            vertices.add(new BlockPos(box.maxX(), box.minY(), box.minZ()));
            vertices.add(new BlockPos(box.maxX(), box.minY(), box.maxZ()));
            vertices.add(new BlockPos(box.minX(), box.minY(), box.maxZ()));
            vertices.add(new BlockPos(box.minX(), box.maxY(), box.minZ()));
            vertices.add(new BlockPos(box.maxX(), box.maxY(), box.minZ()));
            vertices.add(new BlockPos(box.maxX(), box.maxY(), box.maxZ()));
            vertices.add(new BlockPos(box.minX(), box.maxY(), box.maxZ()));
        } else {
            vertices.add(new BlockPos(box.minX(), 0, box.minZ()));
            vertices.add(new BlockPos(box.maxX(), 0, box.minZ()));
            vertices.add(new BlockPos(box.maxX(), 0, box.maxZ()));
            vertices.add(new BlockPos(box.minX(), 0, box.maxZ()));
        }
        return vertices;
    }

    private static List<BlockPos> boxEdges(ClaimBox box, Set<Direction> exclude, boolean is3d, int height, List<BlockPos> vertices, ChunkCache chunkCache) {
        ArrayList<BlockPos> edges = new ArrayList<BlockPos>();
        if (is3d) {
            for (int i = 0; i < 4; ++i) {
                int next = (i + 1) % 4;
                int upperNext = (i + 1) % 4 + 4;
                BlockPos now = vertices.get(i);
                BlockPos nowUpper = vertices.get(i + 4);
                BlockPos nextPos = vertices.get(next);
                BlockPos nextPosUpper = vertices.get(upperNext);
                ClaimDisplay.interpolateEvenly(now, nextPos, true, 10, edges::add);
                ClaimDisplay.interpolateEvenly(nowUpper, nextPosUpper, true, 10, edges::add);
                ClaimDisplay.interpolateEvenly(now, nowUpper, true, 10, edges::add);
            }
        } else {
            Consumer<BlockPos> cons = pos -> {
                Height calc = ClaimDisplay.getHeight(pos.m_123341_(), pos.m_123343_(), height, chunkCache);
                if (calc != null) {
                    if (calc.solid != calc.water) {
                        edges.add(new BlockPos(pos.m_123341_(), calc.water, pos.m_123343_()));
                    }
                    edges.add(new BlockPos(pos.m_123341_(), calc.solid, pos.m_123343_()));
                }
            };
            for (int i = 0; i < 4; ++i) {
                int next = (i + 1) % 4;
                BlockPos now = vertices.get(i);
                BlockPos nextPos = vertices.get(next);
                if (!exclude.contains(Direction.NORTH) && now.m_123343_() == nextPos.m_123343_() && now.m_123343_() == box.minZ()) {
                    ClaimDisplay.interpolateEvenly(now, nextPos, false, 10, cons);
                }
                if (!exclude.contains(Direction.SOUTH) && now.m_123343_() == nextPos.m_123343_() && now.m_123343_() == box.maxZ()) {
                    ClaimDisplay.interpolateEvenly(now, nextPos, false, 10, cons);
                }
                if (!exclude.contains(Direction.WEST) && now.m_123341_() == nextPos.m_123341_() && now.m_123341_() == box.minX()) {
                    ClaimDisplay.interpolateEvenly(now, nextPos, false, 10, cons);
                }
                if (exclude.contains(Direction.EAST) || now.m_123341_() != nextPos.m_123341_() || now.m_123341_() != box.maxX()) continue;
                ClaimDisplay.interpolateEvenly(now, nextPos, false, 10, cons);
            }
        }
        return edges;
    }

    private static void interpolateEvenly(@NotNull BlockPos start, BlockPos end, boolean height, int step, Consumer<BlockPos> cons) {
        int dist;
        BlockPos.MutableBlockPos startM = start.m_122032_();
        BlockPos.MutableBlockPos endM = end.m_122032_();
        int dX = Integer.compare(endM.m_123341_() - startM.m_123341_(), 0);
        int dY = Integer.compare(height ? endM.m_123342_() - startM.m_123342_() : 0, 0);
        int dZ = Integer.compare(endM.m_123343_() - startM.m_123343_(), 0);
        startM.m_122184_(dX, dY, dZ);
        endM.m_122184_(-dX, -dY, -dZ);
        cons.accept(startM.m_7949_());
        cons.accept(endM.m_7949_());
        if (startM.m_123333_((Vec3i)endM) < step) {
            return;
        }
        while ((dist = height ? startM.m_123333_((Vec3i)endM) : ClaimDisplay.dist2d((Vec3i)startM, (Vec3i)endM)) > step) {
            int amount = (int)Math.min((double)step, (double)dist * 0.5);
            startM.m_122184_(dX * amount, dY * amount, dZ * amount);
            endM.m_122184_(-dX * amount, -dY * amount, -dZ * amount);
            cons.accept(startM.m_7949_());
            cons.accept(endM.m_7949_());
            if (dist >= startM.m_123333_((Vec3i)endM) && amount >= step) continue;
            break;
        }
    }

    private static int dist2d(Vec3i first, Vec3i sec) {
        int dX = Math.abs(sec.m_123341_() - first.m_123341_());
        int dZ = Math.abs(sec.m_123343_() - first.m_123343_());
        return dX + dZ;
    }

    public boolean display(ServerPlayer player, boolean remove) {
        if (--this.displayTime % 2 == 0) {
            return this.display.isRemoved();
        }
        ClaimBox dims = this.display.box();
        if (this.pos == null || this.changed(dims)) {
            this.pos = ClaimDisplay.calculatePos(player.m_284548_(), this.display, this.displayHeight);
            if (!ConfigHandler.CONFIG.particleDisplay) {
                PlayerClaimData data = PlayerClaimData.get(player);
                HashSet<ClientBlockDisplayTracker.DisplayData> displayData = new HashSet<ClientBlockDisplayTracker.DisplayData>();
                for (BlockPos pos : this.pos.vertices) {
                    displayData.add(new ClientBlockDisplayTracker.DisplayData(pos, this.type.displayBlock));
                }
                for (BlockPos pos : this.pos.edges) {
                    displayData.add(new ClientBlockDisplayTracker.DisplayData(pos, this.type.displayBlock));
                }
                data.clientBlockDisplayTracker.displayFakeBlocks(this.display.id(), displayData);
            }
        }
        if (ConfigHandler.CONFIG.particleDisplay) {
            for (BlockPos pos : this.pos.vertices) {
                player.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket(this.type.cornerParticle, true, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5 + player.m_284548_().m_213780_().m_188500_() * 1.5, (double)pos.m_123343_() + 0.5, 0.0f, 1.0f, 0.0f, 1.0f, 0));
            }
            for (BlockPos pos : this.pos.edges) {
                player.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket(this.type.middleParticle, true, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5 + player.m_284548_().m_213780_().m_188500_() * 1.5, (double)pos.m_123343_() + 0.5, 0.0f, 1.0f, 0.0f, 1.0f, 0));
            }
        }
        this.prevDims = dims;
        return this.display.isRemoved() || remove && this.displayTime < 0;
    }

    public void onRemoved(ServerPlayer player) {
        if (!ConfigHandler.CONFIG.particleDisplay) {
            PlayerClaimData data = PlayerClaimData.get(player);
            data.clientBlockDisplayTracker.resetFakeBlocks(this.display.id());
        }
    }

    private boolean changed(ClaimBox dims) {
        return this.prevDims == null || !this.prevDims.equals(dims);
    }

    public static Height getHeight(int x, int z, int y, ChunkCache chunkCache) {
        LevelChunk chunk = chunkCache.fetchChunk(x, z);
        if (chunk == null) {
            return null;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        BlockState state = chunk.m_8055_((BlockPos)pos);
        if (state.m_247087_()) {
            boolean startedInLiquid = state.m_278721_();
            boolean inLiquid = false;
            int liquidHeight = pos.m_123342_();
            while (state.m_247087_() && !chunk.m_151570_((BlockPos)pos)) {
                pos.m_122184_(0, -1, 0);
                state = chunk.m_8055_((BlockPos)pos);
                if (startedInLiquid || inLiquid || !state.m_278721_()) continue;
                inLiquid = true;
                liquidHeight = pos.m_123342_();
            }
            int height = pos.m_123342_();
            int n = liquidHeight = inLiquid ? liquidHeight : height;
            if (startedInLiquid) {
                pos.m_122178_(pos.m_123341_(), liquidHeight + 1, pos.m_123343_());
                state = chunk.m_8055_((BlockPos)pos);
                while (state.m_278721_() && !chunk.m_151570_((BlockPos)pos)) {
                    pos.m_122184_(0, 1, 0);
                    state = chunk.m_8055_((BlockPos)pos);
                }
                if (state.m_247087_()) {
                    liquidHeight = pos.m_123342_() - 1;
                }
            }
            return new Height(height, liquidHeight);
        }
        while (!state.m_247087_() && !chunk.m_151570_((BlockPos)pos)) {
            pos.m_122184_(0, 1, 0);
            state = chunk.m_8055_((BlockPos)pos);
        }
        int height = pos.m_123342_() - 1;
        boolean liquid = false;
        while (state.m_278721_() && !state.m_247087_() && !chunk.m_151570_((BlockPos)pos)) {
            pos.m_122184_(0, 1, 0);
            liquid = true;
            state = chunk.m_8055_((BlockPos)pos);
        }
        return new Height(height, liquid ? pos.m_123342_() - 1 : height);
    }

    public int hashCode() {
        return this.display.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClaimDisplay) {
            return this.display.equals(((ClaimDisplay)obj).display);
        }
        return false;
    }

    public static class ChunkCache {
        private final Map<ChunkPos, LevelChunk> chunkCache = new HashMap<ChunkPos, LevelChunk>();
        private final ServerLevel level;

        public ChunkCache(ServerLevel serverLevel) {
            this.level = serverLevel;
        }

        public LevelChunk fetchChunk(int x, int z) {
            ChunkPos pos = new ChunkPos(SectionPos.m_123171_((int)x), SectionPos.m_123171_((int)z));
            return this.chunkCache.computeIfAbsent(pos, k -> {
                if (!this.level.m_7232_(pos.f_45578_, pos.f_45579_)) {
                    return null;
                }
                return this.level.m_6325_(pos.f_45578_, pos.f_45579_);
            });
        }
    }

    public record Height(int solid, int water) {
    }

    record DisplayBoxPos(List<BlockPos> vertices, List<BlockPos> edges) {
    }
}

