/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.model;

import com.google.common.math.IntMath;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.GenericTextureGenerator;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.OffsettingSpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.RecolorSpriteTransformer;
import slimeknights.tconstruct.library.client.data.util.DataGenSpriteReader;
import slimeknights.tconstruct.shared.block.SlimeType;

public class ModelSpriteProvider
extends GenericTextureGenerator {
    private final List<CompletableFuture<?>> tasks = new ArrayList();
    private final DataGenSpriteReader spriteReader;

    public ModelSpriteProvider(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, existingFileHelper, "textures");
        this.spriteReader = new DataGenSpriteReader(existingFileHelper, "textures");
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ResourceLocation rootsSide = TConstruct.getResource("block/wood/enderbark/roots");
        ResourceLocation rootsTop = TConstruct.getResource("block/wood/enderbark/roots_top");
        for (SlimeType slime : SlimeType.values()) {
            String name = slime.m_7912_();
            ResourceLocation congealed = TConstruct.getResource("block/slime/storage/congealed_" + name);
            this.stackSprites(cache, TConstruct.getResource("block/wood/enderbark/roots/" + name), rootsSide, congealed);
            this.stackSprites(cache, TConstruct.getResource("block/wood/enderbark/roots/" + name + "_top"), rootsTop, congealed);
        }
        RecolorSpriteTransformer stoneColor = new RecolorSpriteTransformer(GreyToColorMapping.builderFromBlack().addARGB(63, -15198184).addARGB(102, -11974327).addARGB(140, -10855846).addARGB(178, -8882313).addARGB(216, -6975091).addARGB(255, -5000785).build());
        this.transformSprite(cache, TConstruct.getResource("item/tool/parts/plating_helmet"), TConstruct.getResource("item/tool/armor/plate/helmet/plating"), new OffsettingSpriteTransformer(stoneColor, 0, 2));
        this.transformSprite(cache, TConstruct.getResource("item/tool/parts/plating_chestplate"), TConstruct.getResource("item/tool/armor/plate/chestplate/plating"), stoneColor);
        this.transformSprite(cache, TConstruct.getResource("item/tool/parts/plating_leggings"), TConstruct.getResource("item/tool/armor/plate/leggings/plating"), new OffsettingSpriteTransformer(stoneColor, 0, 1));
        this.transformSprite(cache, TConstruct.getResource("item/tool/parts/plating_boots"), TConstruct.getResource("item/tool/armor/plate/boots/plating"), stoneColor);
        return CompletableFuture.allOf(this.tasks.toArray(new CompletableFuture[0])).thenRunAsync(this.spriteReader::closeAll);
    }

    private static int lcm(int a, int b) {
        return a * (b / IntMath.gcd((int)a, (int)b));
    }

    protected void transformSprite(CachedOutput cache, ResourceLocation output, ResourceLocation input, ISpriteTransformer transformer) {
        try {
            NativeImage original = this.spriteReader.read(input);
            NativeImage generated = transformer.transformCopy(original, true);
            this.tasks.add(this.saveImage(cache, output, generated));
            JsonObject meta = transformer.animationMeta(original);
            if (meta != null) {
                this.tasks.add(this.saveMetadata(cache, output, meta));
            }
        }
        catch (IOException e) {
            TConstruct.LOG.error("Error transforming sprite {} into {}", (Object)input, (Object)output, (Object)e);
            this.tasks.add(CompletableFuture.failedFuture(e));
        }
    }

    protected void stackSprites(CachedOutput cache, ResourceLocation output, ResourceLocation ... inputs) {
        List<NativeImage> sprites = Arrays.stream(inputs).map(path -> {
            try {
                return this.spriteReader.read((ResourceLocation)path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).toList();
        int width = 1;
        int height = 1;
        ResourceLocation metaLocation = null;
        for (int i = 0; i < sprites.size(); ++i) {
            NativeImage sprite = sprites.get(i);
            width = ModelSpriteProvider.lcm(width, sprite.m_84982_());
            height = ModelSpriteProvider.lcm(height, sprite.m_85084_());
            ResourceLocation location = inputs[i];
            if (!this.spriteReader.metadataExists(location)) continue;
            if (metaLocation == null) {
                metaLocation = location;
                continue;
            }
            throw new IllegalStateException("Multiple sprites have metadata, this will not work, found " + metaLocation + " and " + location);
        }
        NativeImage generated = this.spriteReader.create(width, height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int color = 0;
                for (NativeImage sprite : sprites) {
                    int spriteColor = sprite.m_84985_(x % sprite.m_85084_(), y % sprite.m_85084_());
                    if (FastColor.ABGR32.m_266503_((int)spriteColor) == 0) continue;
                    color = spriteColor;
                    break;
                }
                generated.m_84988_(x, y, color);
            }
        }
        this.tasks.add(this.saveImage(cache, output, generated));
        if (metaLocation != null) {
            try {
                this.tasks.add(this.saveMetadata(cache, output, this.spriteReader.readMetadata(metaLocation)));
            }
            catch (IOException e) {
                TConstruct.LOG.error("Failed to save sprite metadata", (Throwable)e);
                this.tasks.add(CompletableFuture.failedFuture(e));
            }
        }
    }

    public String m_6055_() {
        return "Tinkers' Construct model sprite provider";
    }
}

