/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.registration;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.deferred.DeferredRegisterWrapper;
import slimeknights.mantle.registration.object.EnumObject;

public class PotionDeferredRegister
extends DeferredRegisterWrapper<Potion> {
    public PotionDeferredRegister(String modID) {
        super(Registries.f_256973_, modID);
    }

    public RegistryObject<Potion> register(String name, Supplier<Potion> potion) {
        return this.register.register(name, potion);
    }

    public Builder registerTypes(String name, Supplier<? extends MobEffect> effect, int duration, int amplifier) {
        return new Builder(name, effect, duration, amplifier);
    }

    public Builder registerTypes(RegistryObject<? extends MobEffect> effect, int duration, int amplifier) {
        return new Builder(effect.getId().m_135815_(), (Supplier<? extends MobEffect>)effect, duration, amplifier);
    }

    public Builder registerTypes(RegistryObject<? extends MobEffect> effect) {
        return this.registerTypes(effect, 3600, 0);
    }

    public class Builder {
        private final EnumObject.Builder<PotionType, Potion> builder = new EnumObject.Builder(PotionType.class);
        private final String name;
        private final Supplier<? extends MobEffect> effect;
        private final int duration;
        private final int amplifier;

        private Builder(String name, Supplier<? extends MobEffect> effect, int duration, int amplifier) {
            this.name = name;
            this.effect = effect;
            this.duration = duration;
            this.amplifier = amplifier;
            this.with(PotionType.NORMAL, duration, amplifier);
        }

        private Builder with(PotionType type, int duration, int amplifier) {
            String prefix = type == PotionType.NORMAL ? "" : type.toString().toLowerCase(Locale.ROOT);
            this.builder.put((Enum)type, PotionDeferredRegister.this.register(prefix + "_" + this.name, () -> new Potion(PotionDeferredRegister.this.modID + "." + this.name, new MobEffectInstance[]{new MobEffectInstance(this.effect.get(), duration, amplifier)})));
            return this;
        }

        public Builder withStrong(int duration, int amplifier) {
            return this.with(PotionType.STRONG, duration, amplifier);
        }

        public Builder withStrong() {
            return this.withStrong(this.duration / 2, this.amplifier + 1);
        }

        public Builder withLong(int duration, int amplifier) {
            return this.with(PotionType.LONG, duration, amplifier);
        }

        public Builder withLong() {
            return this.withLong(this.duration * 8 / 3, this.amplifier);
        }

        public EnumObject<PotionType, Potion> build() {
            return this.builder.build();
        }
    }

    public static enum PotionType {
        NORMAL,
        LONG,
        STRONG;

    }
}

