/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.sectiontransformer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.transformer.BookTransformer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.TConstruct;

public abstract class AbstractTagInjectingTransformer<T>
extends BookTransformer {
    private static final Comparator<PageData> COMPARATOR = Comparator.comparing(PageData::getTitle);
    private final ResourceKey<? extends Registry<T>> registry;
    private final ResourceLocation key;
    private final ResourceLocation pageType;

    protected Iterator<T> getTagEntries(TagKey<T> tag) {
        return RegistryHelper.getTagValueStream(tag).iterator();
    }

    protected abstract ResourceLocation getId(T var1);

    protected abstract PageContent createFallback(T var1);

    protected int addPages(SectionData section, Map<ResourceLocation, JsonElement> extraData, int index) {
        JsonElement element = extraData.get(this.key);
        if (element != null) {
            try {
                JsonObject load = GsonHelper.m_13918_((JsonElement)element, (String)this.key.toString());
                String path = GsonHelper.m_13906_((JsonObject)load, (String)"path");
                boolean sort = GsonHelper.m_13855_((JsonObject)load, (String)"sort", (boolean)true);
                Object prefix = "";
                if (load.has("prefix")) {
                    prefix = GsonHelper.m_13906_((JsonObject)load, (String)"prefix") + ".";
                }
                ArrayList<PageData> newPages = new ArrayList<PageData>();
                Iterator<T> iterator = this.getTagEntries(TagKey.m_203882_(this.registry, (ResourceLocation)JsonHelper.getResourceLocation((JsonObject)load, (String)"tag")));
                while (iterator.hasNext()) {
                    T value = iterator.next();
                    PageData newPage = new PageData(true);
                    newPage.parent = section;
                    newPage.source = section.source;
                    newPage.type = this.pageType;
                    ResourceLocation id = this.getId(value);
                    newPage.name = (String)prefix + id.m_135827_() + "." + id.m_135815_();
                    String data = path + "/" + id.m_135827_() + "_" + id.m_135815_() + ".json";
                    if (section.source.resourceExists(section.source.getResourceLocation(data))) {
                        newPage.data = data;
                    } else {
                        newPage.content = this.createFallback(value);
                    }
                    newPage.load();
                    newPages.add(newPage);
                }
                if (sort) {
                    newPages.sort(COMPARATOR);
                }
                section.pages.addAll(index, newPages);
                return newPages.size();
            }
            catch (JsonParseException e) {
                TConstruct.LOG.error("Failed to parse tag for book page injecting", (Throwable)e);
            }
        }
        return 0;
    }

    public void transform(BookData book) {
        for (SectionData section : book.sections) {
            for (int i = this.addPages(section, section.extraData, 0); i < section.pages.size(); ++i) {
                i += this.addPages(section, ((PageData)section.pages.get((int)i)).extraData, i + 1);
            }
        }
    }

    public AbstractTagInjectingTransformer(ResourceKey<? extends Registry<T>> registry, ResourceLocation key, ResourceLocation pageType) {
        this.registry = registry;
        this.key = key;
        this.pageType = pageType;
    }
}

