/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.tconstruct.library.client.data.GenericTextureGenerator;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.data.util.DataGenSpriteReader;
import slimeknights.tconstruct.library.materials.definition.MaterialId;

public class TrimMaterialPaletteGenerator
extends GenericTextureGenerator {
    private static final String PALETTE_FOLDER = "trims/color_palettes";
    private static final String PALETTE_TEXTURES = "textures/trims/color_palettes";
    private final String name;
    private final MaterialId[] materials;
    private final AbstractMaterialSpriteProvider materialProvider;

    public TrimMaterialPaletteGenerator(PackOutput packOutput, String name, ExistingFileHelper existingFileHelper, AbstractMaterialSpriteProvider materialProvider, MaterialId ... materials) {
        super(packOutput, existingFileHelper, "");
        this.name = name;
        this.materialProvider = materialProvider;
        this.materials = materials;
    }

    protected ISpriteTransformer getTransformer(MaterialId material) {
        return Objects.requireNonNull(this.materialProvider.getMaterialInfo(material), "Missing material provider " + material).getTransformer();
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        assert (this.existingFileHelper != null);
        DataGenSpriteReader spriteReader = new DataGenSpriteReader(this.existingFileHelper, PALETTE_TEXTURES);
        try {
            JsonObject trimmedJson = new JsonObject();
            JsonObject values = new JsonObject();
            for (MaterialId material2 : this.materials) {
                values.addProperty(material2.m_246208_("trims/color_palettes/").toString(), material2.getSuffix());
            }
            trimmedJson.add("pairs", (JsonElement)values);
            NativeImage original = spriteReader.read(new ResourceLocation("trim_palette"));
            return TrimMaterialPaletteGenerator.allOf(Stream.concat(Stream.of(this.saveJson(cache, new ResourceLocation("trimmed", "maps/unchecked/custom_trim_material_permutations"), trimmedJson)), Arrays.stream(this.materials).map(material -> this.saveImage(cache, material.m_246208_("textures/trims/color_palettes/"), this.getTransformer((MaterialId)material).transformCopy(original, false))))).thenRunAsync(spriteReader::closeAll);
        }
        catch (IOException ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    public String m_6055_() {
        return this.name + " Material Trim Palette Generator";
    }
}

