/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.predicate.tool;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.tconstruct.library.json.predicate.tool.ToolStackPredicate;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record StatInSetPredicate<T>(IToolStat<T> stat, Set<T> values) implements ToolStackPredicate
{
    public static final RecordLoadable<StatInSetPredicate<?>> LOADER = new RecordLoadable<StatInSetPredicate<?>>(){

        public StatInSetPredicate<?> deserialize(JsonObject json, TypedMap context) {
            return 1.deserialize(json, (IToolStat)ToolStats.LOADER.getIfPresent(json, "stat", context));
        }

        private static <T> StatInSetPredicate<T> deserialize(JsonObject json, IToolStat<T> stat) {
            ImmutableSet values = ImmutableSet.copyOf((Collection)JsonHelper.parseList((JsonObject)json, (String)"values", (element, key) -> stat.deserialize((JsonElement)element)));
            return new StatInSetPredicate<T>(stat, values);
        }

        public void serialize(StatInSetPredicate<?> object, JsonObject json) {
            json.add("stat", ToolStats.LOADER.serialize(object.stat));
            1.serializeSet(object, json);
        }

        private static <T> void serializeSet(StatInSetPredicate<T> object, JsonObject json) {
            JsonArray array = new JsonArray();
            for (Object value : object.values) {
                array.add(object.stat.serialize(value));
            }
            json.add("values", (JsonElement)array);
        }

        public StatInSetPredicate<?> decode(FriendlyByteBuf buffer, TypedMap context) {
            return 1.fromNetwork(buffer, (IToolStat)ToolStats.LOADER.decode(buffer, context));
        }

        private static <T> StatInSetPredicate<T> fromNetwork(FriendlyByteBuf buffer, IToolStat<T> stat) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            int max = buffer.m_130242_();
            for (int i = 0; i < max; ++i) {
                builder.add(stat.fromNetwork(buffer));
            }
            return new StatInSetPredicate<T>(stat, builder.build());
        }

        public void encode(FriendlyByteBuf buffer, StatInSetPredicate<?> object) {
            ToolStats.LOADER.encode(buffer, object.stat);
            1.setToNetwork(object, buffer);
        }

        private static <T> void setToNetwork(StatInSetPredicate<T> object, FriendlyByteBuf buffer) {
            buffer.m_130130_(object.values.size());
            for (Object value : object.values) {
                object.stat.toNetwork(buffer, value);
            }
        }
    };

    public StatInSetPredicate(IToolStat<T> stat, T value) {
        this(stat, Set.of(value));
    }

    public boolean matches(IToolStackView tool) {
        return this.values.contains(tool.getStats().get(this.stat));
    }

    public RecordLoadable<StatInSetPredicate<?>> getLoader() {
        return LOADER;
    }
}

