/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.stats;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.utils.IdParser;
import slimeknights.tconstruct.library.utils.ResourceId;

public class MaterialStatsId
extends ResourceId {
    public static final IdParser<MaterialStatsId> PARSER = new IdParser<MaterialStatsId>(MaterialStatsId::new, "Material Stat Type");

    public MaterialStatsId(String text) {
        super(text);
    }

    public MaterialStatsId(String namespaceIn, String pathIn) {
        super(namespaceIn, pathIn);
    }

    public MaterialStatsId(ResourceLocation location) {
        super(location);
    }

    private MaterialStatsId(String namespace, String path, @Nullable ResourceLocation.Dummy pDummy) {
        super(namespace, path, pDummy);
    }

    public boolean canUseMaterial(MaterialId material) {
        return MaterialRegistry.getInstance().getMaterialStats(material.getId(), this).isPresent();
    }

    @Nullable
    public static MaterialStatsId tryParse(String string) {
        return MaterialStatsId.tryParse(string, (namespace, path) -> new MaterialStatsId((String)namespace, (String)path, null));
    }

    @Nullable
    public static MaterialStatsId tryBuild(String namespace, String path) {
        return MaterialStatsId.tryBuild(namespace, path, (n, p) -> new MaterialStatsId(namespace, path, null));
    }
}

