/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.module;

import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.registration.object.IdAwareObject;

public class ModuleHook<T>
implements IdAwareObject {
    private final ResourceLocation id;
    private final Class<T> filter;
    @Nullable
    private final Function<Collection<T>, T> merger;
    private final T defaultInstance;

    public ModuleHook(ResourceLocation name, Class<T> filter, T defaultInstance) {
        this(name, filter, null, defaultInstance);
    }

    public boolean isValid(Object module) {
        return this.filter.isInstance(module);
    }

    public boolean supportsHook(Class<?> classType) {
        return classType.isAssignableFrom(this.filter);
    }

    public T cast(Object module) {
        return (T)module;
    }

    public boolean canMerge() {
        return this.merger != null;
    }

    public T merge(Collection<T> modules) {
        if (modules.isEmpty()) {
            return this.defaultInstance;
        }
        if (modules.size() == 1) {
            return modules.iterator().next();
        }
        if (this.merger == null) {
            throw new IllegalStateException(this.id + " does not support merging");
        }
        return this.merger.apply(modules);
    }

    public String toString() {
        return "ModifierHook{" + this.id + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleHook that = (ModuleHook)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public ModuleHook(ResourceLocation id, Class<T> filter, @Nullable Function<Collection<T>, T> merger, T defaultInstance) {
        this.id = id;
        this.filter = filter;
        this.merger = merger;
        this.defaultInstance = defaultInstance;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public T getDefaultInstance() {
        return this.defaultInstance;
    }
}

