/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeCache;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.utils.SimpleCache;

public class MaterialCastingLookup {
    private static final Object2IntMap<IMaterialItem> ITEM_COST_LOOKUP = new Object2IntOpenHashMap(50);
    private static final List<MaterialFluidRecipe> CASTING_FLUIDS = new ArrayList<MaterialFluidRecipe>();
    private static final List<MaterialFluidRecipe> COMPOSITE_FLUIDS = new ArrayList<MaterialFluidRecipe>();
    private static final SimpleCache<Fluid, MaterialFluidRecipe> CASTING_CACHE = new SimpleCache<Fluid, MaterialFluidRecipe>(fluid -> {
        for (MaterialFluidRecipe recipe : CASTING_FLUIDS) {
            if (!recipe.matches((Fluid)fluid)) continue;
            return recipe;
        }
        return MaterialFluidRecipe.EMPTY;
    });
    private static final SimpleCache<CompositeCacheKey, MaterialFluidRecipe> COMPOSITE_CACHE = new SimpleCache<CompositeCacheKey, MaterialFluidRecipe>(key -> {
        for (MaterialFluidRecipe recipe : COMPOSITE_FLUIDS) {
            if (!recipe.matches(key.fluid, key.input)) continue;
            return recipe;
        }
        return MaterialFluidRecipe.EMPTY;
    });
    private static final SimpleCache<MaterialVariantId, List<MaterialFluidRecipe>> MATERIAL_CASTABLE = new SimpleCache<MaterialVariantId, List>(material -> CASTING_FLUIDS.stream().filter(recipe -> material.matchesVariant(recipe.getOutput())).collect(Collectors.toList()));
    private static final SimpleCache<MaterialVariantId, List<MaterialFluidRecipe>> MATERIAL_COMPOSITE = new SimpleCache<MaterialVariantId, List>(material -> COMPOSITE_FLUIDS.stream().filter(recipe -> material.matchesVariant(recipe.getOutput())).collect(Collectors.toList()));
    private static final RecipeCacheInvalidator.DuelSidedListener LISTENER = RecipeCacheInvalidator.addDuelSidedListener(() -> {
        ITEM_COST_LOOKUP.clear();
        CASTING_FLUIDS.clear();
        CASTING_CACHE.clear();
        MATERIAL_CASTABLE.clear();
        MATERIAL_COMPOSITE.clear();
        COMPOSITE_FLUIDS.clear();
        COMPOSITE_CACHE.clear();
    });

    public static void registerItemCost(IMaterialItem item, int cost) {
        LISTENER.checkClear();
        if (ITEM_COST_LOOKUP.containsKey((Object)item)) {
            int original = ITEM_COST_LOOKUP.getInt((Object)item);
            if (cost != original) {
                TConstruct.LOG.error("Inconsistent cost for item {}", (Object)BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_()));
                ITEM_COST_LOOKUP.put((Object)item, Math.min(cost, original));
            }
        } else {
            ITEM_COST_LOOKUP.put((Object)item, cost);
        }
    }

    public static void registerFluid(MaterialFluidRecipe recipe) {
        LISTENER.checkClear();
        if (recipe.getInput() == null) {
            CASTING_FLUIDS.add(recipe);
        } else {
            COMPOSITE_FLUIDS.add(recipe);
        }
        MaterialRecipeCache.addKnownVariant(recipe.getOutput().getVariant());
    }

    public static int getItemCost(IMaterialItem item) {
        return ITEM_COST_LOOKUP.getOrDefault((Object)item, 0);
    }

    public static int getItemCost(Item item) {
        return ITEM_COST_LOOKUP.getOrDefault((Object)item, 0);
    }

    public static Collection<Object2IntMap.Entry<IMaterialItem>> getAllItemCosts() {
        return ITEM_COST_LOOKUP.object2IntEntrySet();
    }

    public static MaterialFluidRecipe getCastingFluid(Fluid fluid) {
        return CASTING_CACHE.apply(fluid);
    }

    public static MaterialFluidRecipe getCompositeFluid(Fluid fluid, MaterialVariantId material) {
        return COMPOSITE_CACHE.apply(new CompositeCacheKey(fluid, material));
    }

    public static List<MaterialFluidRecipe> getCastingFluids(MaterialVariantId material) {
        return MATERIAL_CASTABLE.apply(material);
    }

    public static List<MaterialFluidRecipe> getCompositeFluids(MaterialVariantId material) {
        return MATERIAL_COMPOSITE.apply(material);
    }

    public static Collection<MaterialFluidRecipe> getAllCastingFluids() {
        return CASTING_FLUIDS;
    }

    public static Collection<MaterialFluidRecipe> getAllCompositeFluids() {
        return COMPOSITE_FLUIDS;
    }

    private MaterialCastingLookup() {
    }

    private record CompositeCacheKey(Fluid fluid, MaterialVariantId input) {
    }
}

