/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import slimeknights.mantle.recipe.ICommonRecipe;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.material.IMaterialValue;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.tables.TinkerTables;

public interface IPartBuilderRecipe
extends ICommonRecipe<IPartBuilderContainer> {
    public static final Ingredient DEFAULT_PATTERNS = Ingredient.m_204132_(TinkerTags.Items.DEFAULT_PATTERNS);

    public Pattern getPattern();

    default public Stream<Pattern> getPatterns(IPartBuilderContainer inv) {
        return Stream.of(this.getPattern());
    }

    public int getCost();

    public boolean partialMatch(IPartBuilderContainer var1);

    default public int getItemsUsed(IPartBuilderContainer inv) {
        return Optional.ofNullable(inv.getMaterial()).map(mat -> mat.getItemsUsed(this.getCost())).orElse(1);
    }

    default public ItemStack assemble(IPartBuilderContainer inv, RegistryAccess access, Pattern pattern) {
        return this.m_5874_((Container)inv, access);
    }

    default public RecipeType<?> m_6671_() {
        return (RecipeType)TinkerRecipeTypes.PART_BUILDER.get();
    }

    default public ItemStack m_8042_() {
        return new ItemStack(TinkerTables.partBuilder);
    }

    default public ItemStack getLeftover(IPartBuilderContainer inventoryWrapper, Pattern pattern) {
        int value;
        IMaterialValue recipe = inventoryWrapper.getMaterial();
        if (recipe != null && (value = recipe.getValue()) > 1) {
            int needed = recipe.getNeeded();
            int remainder = (value - this.getCost() * needed) % value;
            if (remainder < 0) {
                remainder += value;
            }
            if (remainder > 0) {
                ItemStack leftover = recipe.getLeftover();
                if (!leftover.m_41619_()) {
                    leftover.m_41764_(leftover.m_41613_() * remainder / needed);
                }
                return leftover;
            }
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    default public Component getTitle() {
        return null;
    }

    default public List<Component> getText(IPartBuilderContainer inv) {
        return Collections.emptyList();
    }
}

