/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.context;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.library.utils.Util;

public class ToolAttackContext {
    @Nonnull
    private final LivingEntity attacker;
    @Nullable
    private final Player playerAttacker;
    @Nonnull
    private final InteractionHand hand;
    @Nonnull
    private final EquipmentSlot slotType;
    @Nonnull
    private final Entity target;
    @Nullable
    private final LivingEntity livingTarget;
    private final boolean isCritical;
    private final float cooldown;
    private final boolean isExtraAttack;

    public ToolAttackContext(LivingEntity attacker, @Nullable Player playerAttacker, InteractionHand hand, Entity target, @Nullable LivingEntity livingTarget, boolean isCritical, float cooldown, boolean isExtraAttack) {
        this(attacker, playerAttacker, hand, Util.getSlotType(hand), target, livingTarget, isCritical, cooldown, isExtraAttack);
    }

    public boolean isFullyCharged() {
        return this.getCooldown() > 0.9f;
    }

    public Level getLevel() {
        return this.attacker.m_9236_();
    }

    @Nonnull
    public LivingEntity getAttacker() {
        return this.attacker;
    }

    @Nullable
    public Player getPlayerAttacker() {
        return this.playerAttacker;
    }

    @Nonnull
    public InteractionHand getHand() {
        return this.hand;
    }

    @Nonnull
    public EquipmentSlot getSlotType() {
        return this.slotType;
    }

    @Nonnull
    public Entity getTarget() {
        return this.target;
    }

    @Nullable
    public LivingEntity getLivingTarget() {
        return this.livingTarget;
    }

    public boolean isCritical() {
        return this.isCritical;
    }

    public float getCooldown() {
        return this.cooldown;
    }

    public boolean isExtraAttack() {
        return this.isExtraAttack;
    }

    public ToolAttackContext(@Nonnull LivingEntity attacker, @Nullable Player playerAttacker, @Nonnull InteractionHand hand, @Nonnull EquipmentSlot slotType, @Nonnull Entity target, @Nullable LivingEntity livingTarget, boolean isCritical, float cooldown, boolean isExtraAttack) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        if (slotType == null) {
            throw new NullPointerException("slotType is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.attacker = attacker;
        this.playerAttacker = playerAttacker;
        this.hand = hand;
        this.slotType = slotType;
        this.target = target;
        this.livingTarget = livingTarget;
        this.isCritical = isCritical;
        this.cooldown = cooldown;
        this.isExtraAttack = isExtraAttack;
    }
}

