/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.layout;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;

public class UpdateTinkerSlotLayoutsPacket
implements IThreadsafePacket {
    @VisibleForTesting
    private final Collection<StationSlotLayout> layouts;

    public UpdateTinkerSlotLayoutsPacket(FriendlyByteBuf buffer) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int max = buffer.m_130242_();
        for (int i = 0; i < max; ++i) {
            builder.add((Object)StationSlotLayout.read(buffer));
        }
        this.layouts = builder.build();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.layouts.size());
        for (StationSlotLayout layout : this.layouts) {
            layout.write(buffer);
        }
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        StationSlotLayoutLoader.getInstance().setSlots(this.layouts);
    }

    public UpdateTinkerSlotLayoutsPacket(Collection<StationSlotLayout> layouts) {
        this.layouts = layouts;
    }

    Collection<StationSlotLayout> getLayouts() {
        return this.layouts;
    }
}

