/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class MultiplierNBT {
    public static final Loadable<MultiplierNBT> LOADABLE = ToolStats.NUMERIC_LOADER.mapWithValues((Loadable)FloatLoadable.ANY, 0).flatXmap(MultiplierNBT::new, m -> m.stats);
    public static final MultiplierNBT EMPTY = new MultiplierNBT((Map<INumericToolStat<?>, Float>)ImmutableMap.of());
    private final Map<INumericToolStat<?>, Float> stats;

    public static Builder builder() {
        return new Builder();
    }

    public Set<INumericToolStat<?>> getContainedStats() {
        return this.stats.keySet();
    }

    public boolean hasStat(INumericToolStat<?> stat) {
        return this.stats.containsKey(stat);
    }

    public float get(INumericToolStat<?> stat) {
        return this.stats.getOrDefault(stat, Float.valueOf(1.0f)).floatValue();
    }

    public static MultiplierNBT readFromNBT(@Nullable Tag inbt) {
        if (inbt == null || inbt.m_7060_() != 10) {
            return EMPTY;
        }
        Builder builder = MultiplierNBT.builder();
        CompoundTag nbt = (CompoundTag)inbt;
        for (String key : nbt.m_128431_()) {
            IToolStat<?> iToolStat;
            if (!nbt.m_128425_(key, 99) || !((iToolStat = StatsNBT.readStatIdFromNBT(key)) instanceof INumericToolStat)) continue;
            INumericToolStat stat = (INumericToolStat)iToolStat;
            builder.set(stat, nbt.m_128457_(key));
        }
        return builder.build();
    }

    public CompoundTag serializeToNBT() {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<INumericToolStat<?>, Float> entry : this.stats.entrySet()) {
            nbt.m_128350_(entry.getKey().getName().toString(), entry.getValue().floatValue());
        }
        return nbt;
    }

    MultiplierNBT(Map<INumericToolStat<?>, Float> stats) {
        this.stats = stats;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiplierNBT)) {
            return false;
        }
        MultiplierNBT other = (MultiplierNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<INumericToolStat<?>, Float> this$stats = this.stats;
        Map<INumericToolStat<?>, Float> other$stats = other.stats;
        return !(this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiplierNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<INumericToolStat<?>, Float> $stats = this.stats;
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        return result;
    }

    public String toString() {
        return "MultiplierNBT(stats=" + this.stats + ")";
    }

    public static class Builder {
        private final ImmutableMap.Builder<INumericToolStat<?>, Float> builder = ImmutableMap.builder();

        private Builder() {
        }

        public Builder set(INumericToolStat<?> stat, float value) {
            if (value != 1.0f) {
                this.builder.put(stat, (Object)Float.valueOf(Math.max(value, 0.0f)));
            }
            return this;
        }

        public MultiplierNBT build() {
            ImmutableMap map = this.builder.build();
            if (map.isEmpty()) {
                return EMPTY;
            }
            return new MultiplierNBT((Map<INumericToolStat<?>, Float>)map);
        }
    }
}

