/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.smeltery.block.entity.tank.ISmelteryTankHandler;

public class SmelteryTankUpdatePacket
implements IThreadsafePacket {
    private final BlockPos pos;
    private final List<FluidStack> fluids;

    public SmelteryTankUpdatePacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        int size = buffer.m_130242_();
        this.fluids = new ArrayList<FluidStack>(size);
        for (int i = 0; i < size; ++i) {
            this.fluids.add(buffer.readFluidStack());
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130130_(this.fluids.size());
        for (FluidStack fluid : this.fluids) {
            buffer.writeFluidStack(fluid);
        }
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    public SmelteryTankUpdatePacket(BlockPos pos, List<FluidStack> fluids) {
        this.pos = pos;
        this.fluids = fluids;
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(SmelteryTankUpdatePacket packet) {
            BlockEntityHelper.get(ISmelteryTankHandler.class, (BlockGetter)Minecraft.m_91087_().f_91073_, (BlockPos)packet.pos).ifPresent(te -> te.updateFluidsFromPacket(packet.fluids));
        }
    }
}

