/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import java.util.Iterator;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.ContentBlank;
import slimeknights.mantle.client.book.transformer.BookTransformer;

public abstract class ContentPadding
extends ContentBlank {
    public static final ResourceLocation LEFT_ID = Mantle.getResource("left_padding");
    public static final ResourceLocation RIGHT_ID = Mantle.getResource("right_padding");

    public abstract boolean isLeft();

    public static class PaddingBookTransformer
    extends BookTransformer {
        public static final PaddingBookTransformer INSTANCE = new PaddingBookTransformer();

        private PaddingBookTransformer() {
        }

        @Override
        public void transform(BookData bookData) {
            boolean previousLeft = true;
            for (SectionData section : bookData.sections) {
                Iterator<PageData> pageIterator = section.pages.iterator();
                while (pageIterator.hasNext()) {
                    PageData data = pageIterator.next();
                    if (data.content instanceof ContentPadding && ((ContentPadding)data.content).isLeft() == previousLeft) {
                        pageIterator.remove();
                        continue;
                    }
                    previousLeft = !previousLeft;
                }
            }
        }
    }

    public static class ContentRightPadding
    extends ContentPadding {
        @Override
        public boolean isLeft() {
            return false;
        }
    }

    public static class ContentLeftPadding
    extends ContentPadding {
        @Override
        public boolean isLeft() {
            return true;
        }
    }
}

