/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.client.book.data.element.IDataElement;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;

public class IngredientData
implements IDataElement {
    public SizedIngredient[] ingredients = new SizedIngredient[0];
    public String action;
    private transient String error;
    private transient NonNullList<ItemStack> items;
    private transient boolean customData;

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public static IngredientData getItemStackData(ItemStack stack) {
        IngredientData data = new IngredientData();
        data.items = NonNullList.m_122780_((int)1, (Object)stack);
        data.customData = true;
        return data;
    }

    public static IngredientData getItemStackData(NonNullList<ItemStack> items) {
        IngredientData data = new IngredientData();
        data.items = items;
        data.customData = true;
        return data;
    }

    @Override
    public void load(BookRepository source) {
        if (this.customData) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (SizedIngredient ingredient : this.ingredients) {
            if (ingredient == null) continue;
            stacks.addAll(ingredient.getMatchingStacks());
        }
        if (this.ingredients == null || stacks.isEmpty() || !StringUtil.m_14408_((String)this.error)) {
            this.items = NonNullList.m_122780_((int)1, (Object)this.getMissingItem());
            return;
        }
        this.items = NonNullList.m_122783_((Object)this.getMissingItem(), (Object[])stacks.toArray(new ItemStack[0]));
    }

    private ItemStack getMissingItem() {
        return this.getMissingItem(this.error);
    }

    private ItemStack getMissingItem(String error) {
        ItemStack missingItem = new ItemStack((ItemLike)Items.f_42127_);
        CompoundTag display = missingItem.m_41698_("display");
        display.m_128359_("Name", "\u00a7rError Loading Item");
        ListTag lore = new ListTag();
        if (!StringUtil.m_14408_((String)error)) {
            lore.add((Object)StringTag.m_129297_((String)"\u00a7r\u00a7eError:"));
            lore.add((Object)StringTag.m_129297_((String)("\u00a7r\u00a7e" + error)));
        }
        display.m_128365_("Lore", (Tag)lore);
        return missingItem;
    }

    public static class Deserializer
    implements JsonDeserializer<IngredientData> {
        public IngredientData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonPrimitive primitive;
            JsonElement action;
            JsonObject object;
            IngredientData data = new IngredientData();
            if (json.isJsonArray()) {
                JsonArray array = json.getAsJsonArray();
                data.ingredients = new SizedIngredient[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    try {
                        data.ingredients[i] = this.readIngredient(array.get(i));
                        continue;
                    }
                    catch (Exception e) {
                        data.ingredients[i] = SizedIngredient.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{data.getMissingItem(e.getMessage())}));
                    }
                }
                return data;
            }
            try {
                data.ingredients = new SizedIngredient[]{this.readIngredient(json)};
            }
            catch (Exception e) {
                data.error = e.getMessage();
                return data;
            }
            if (json.isJsonObject() && (object = json.getAsJsonObject()).has("action") && (action = object.get("action")).isJsonPrimitive() && (primitive = action.getAsJsonPrimitive()).isString()) {
                data.action = primitive.getAsString();
            }
            return data;
        }

        private SizedIngredient readIngredient(JsonElement json) {
            JsonPrimitive primitive;
            if (json.isJsonPrimitive() && (primitive = json.getAsJsonPrimitive()).isString()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(primitive.getAsString()));
                return SizedIngredient.fromItems(new ItemLike[]{item});
            }
            if (!json.isJsonObject()) {
                throw new JsonParseException("Must be an array, string or JSON object");
            }
            JsonObject object = json.getAsJsonObject();
            return SizedIngredient.deserialize(object);
        }
    }
}

