/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.structure;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StructureInfo
implements Predicate<BlockPos> {
    public Map<BlockPos, StructureTemplate.StructureBlockInfo> data = new HashMap<BlockPos, StructureTemplate.StructureBlockInfo>();
    public final int structureHeight;
    public final int structureLength;
    public final int structureWidth;
    public final int maxBlockIndex;
    public int showLayer = -1;
    public int blockIndex;

    public StructureInfo(List<StructureTemplate.StructureBlockInfo> structure) {
        int structureHeight = 0;
        int structureWidth = 0;
        int structureLength = 0;
        for (StructureTemplate.StructureBlockInfo block : structure) {
            BlockPos pos = block.f_74675_();
            structureHeight = Math.max(structureHeight, pos.m_123342_() + 1);
            structureWidth = Math.max(structureWidth, pos.m_123343_() + 1);
            structureLength = Math.max(structureLength, pos.m_123341_() + 1);
            this.data.put(pos, block);
        }
        this.maxBlockIndex = this.blockIndex = structureHeight * structureLength * structureWidth;
        this.structureHeight = structureHeight;
        this.structureLength = structureLength;
        this.structureWidth = structureWidth;
    }

    public void setShowLayer(int layer) {
        this.showLayer = layer;
        if (layer < 0) {
            this.reset();
        } else {
            this.blockIndex = (layer + 1) * (this.structureLength * this.structureWidth) - 1;
        }
    }

    public void reset() {
        this.blockIndex = this.maxBlockIndex;
    }

    public void step() {
        int start = this.blockIndex;
        do {
            if (++this.blockIndex < this.maxBlockIndex) continue;
            this.blockIndex = 0;
        } while (this.isEmpty(this.blockIndex) && this.blockIndex != start);
    }

    private boolean isEmpty(int index) {
        int r = index % (this.structureLength * this.structureWidth);
        int x = r / this.structureWidth;
        int y = index / (this.structureLength * this.structureWidth);
        int z = r % this.structureWidth;
        return !this.data.containsKey(new BlockPos(x, y, z));
    }

    public int getLimiter() {
        return this.blockIndex;
    }

    @Override
    public boolean test(BlockPos blockPos) {
        int index = blockPos.m_123343_() + this.structureWidth * (blockPos.m_123341_() + this.structureLength * blockPos.m_123342_());
        return index <= this.getLimiter();
    }
}

