/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.inventory.MultiModuleContainerMenu;
import slimeknights.mantle.inventory.WrapperSlot;

public class MultiModuleScreen<CONTAINER extends MultiModuleContainerMenu<?>>
extends AbstractContainerScreen<CONTAINER> {
    protected List<ModuleScreen<?, ?>> modules = Lists.newArrayList();
    public int cornerX;
    public int cornerY;
    public int realWidth = -1;
    public int realHeight = -1;

    public MultiModuleScreen(CONTAINER container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    protected void addModule(ModuleScreen<?, ?> module) {
        this.modules.add(module);
    }

    public List<Rect2i> getModuleAreas() {
        ArrayList<Rect2i> areas = new ArrayList<Rect2i>(this.modules.size());
        for (ModuleScreen<?, ?> module : this.modules) {
            areas.add(module.getArea());
        }
        return areas;
    }

    protected void m_7856_() {
        if (this.realWidth > -1) {
            this.f_97726_ = this.realWidth;
            this.f_97727_ = this.realHeight;
        }
        super.m_7856_();
        this.cornerX = this.f_97735_;
        this.cornerY = this.f_97736_;
        this.realWidth = this.f_97726_;
        this.realHeight = this.f_97727_;
        assert (this.f_96541_ != null);
        for (ModuleScreen<?, ?> module : this.modules) {
            this.updateSubmodule(module);
        }
        for (ModuleScreen<?, ?> module : this.modules) {
            module.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            this.updateSubmodule(module);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        for (ModuleScreen<?, ?> module : this.modules) {
            module.handleDrawGuiContainerBackgroundLayer(graphics, partialTicks, mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        this.drawContainerName(graphics);
        this.drawPlayerInventoryName(graphics);
        PoseStack poses = graphics.m_280168_();
        for (ModuleScreen<?, ?> module : this.modules) {
            poses.m_85836_();
            poses.m_252880_((float)(module.f_97735_ - this.f_97735_), (float)(module.f_97736_ - this.f_97736_), 0.0f);
            module.handleDrawGuiContainerForegroundLayer(graphics, mouseX, mouseY);
            poses.m_85849_();
        }
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280072_(graphics, mouseX, mouseY);
        for (ModuleScreen<?, ?> module : this.modules) {
            module.handleRenderHoveredTooltip(graphics, mouseX, mouseY);
        }
    }

    protected void drawBackground(GuiGraphics graphics, ResourceLocation background) {
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280218_(background, this.cornerX, this.cornerY, 0, 0, this.realWidth, this.realHeight);
    }

    protected void drawContainerName(GuiGraphics graphics) {
        graphics.m_280649_(this.f_96547_, this.m_96636_().m_7532_(), 8, 6, 0x404040, false);
    }

    protected void drawPlayerInventoryName(GuiGraphics graphics) {
        assert (Minecraft.m_91087_().f_91074_ != null);
        Component localizedName = Minecraft.m_91087_().f_91074_.m_150109_().m_5446_();
        graphics.m_280649_(this.f_96547_, localizedName.m_7532_(), 8, this.f_97727_ - 96 + 2, 0x404040, false);
    }

    public void m_6574_(Minecraft mc, int width, int height) {
        super.m_6574_(mc, width, height);
        for (ModuleScreen<?, ?> module : this.modules) {
            module.m_6574_(mc, width, height);
            this.updateSubmodule(module);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        int oldX = this.f_97735_;
        int oldY = this.f_97736_;
        int oldW = this.f_97726_;
        int oldH = this.f_97727_;
        this.f_97735_ = this.cornerX;
        this.f_97736_ = this.cornerY;
        this.f_97726_ = this.realWidth;
        this.f_97727_ = this.realHeight;
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
        this.f_97735_ = oldX;
        this.f_97736_ = oldY;
        this.f_97726_ = oldW;
        this.f_97727_ = oldH;
    }

    protected boolean m_6774_(int left, int top, int right, int bottom, double pointX, double pointY) {
        return (pointX -= (double)this.cornerX) >= (double)(left - 1) && pointX < (double)(left + right + 1) && (pointY -= (double)this.cornerY) >= (double)(top - 1) && pointY < (double)(top + bottom + 1);
    }

    protected void updateSubmodule(ModuleScreen<?, ?> module) {
        module.updatePosition(this.cornerX, this.cornerY, this.realWidth, this.realHeight);
        if (module.f_97735_ < this.f_97735_) {
            this.f_97726_ += this.f_97735_ - module.f_97735_;
            this.f_97735_ = module.f_97735_;
        }
        if (module.f_97736_ < this.f_97736_) {
            this.f_97727_ += this.f_97736_ - module.f_97736_;
            this.f_97736_ = module.f_97736_;
        }
        if (module.guiRight() > this.f_97735_ + this.f_97726_) {
            this.f_97726_ = module.guiRight() - this.f_97735_;
        }
        if (module.guiBottom() > this.f_97736_ + this.f_97727_) {
            this.f_97727_ = module.guiBottom() - this.f_97736_;
        }
    }

    public void m_280092_(GuiGraphics graphics, Slot slotIn) {
        ModuleScreen<?, ?> module = this.getModuleForSlot(slotIn.f_40219_);
        if (module != null) {
            Slot slot = slotIn;
            if (slotIn instanceof WrapperSlot) {
                slot = ((WrapperSlot)slotIn).parent;
            }
            if (!module.shouldDrawSlot(slot)) {
                return;
            }
        }
        if (slotIn instanceof WrapperSlot) {
            slotIn.f_40220_ = ((WrapperSlot)slotIn).parent.f_40220_;
            slotIn.f_40221_ = ((WrapperSlot)slotIn).parent.f_40221_;
        }
        super.m_280092_(graphics, slotIn);
    }

    public boolean m_97774_(Slot slotIn, double mouseX, double mouseY) {
        ModuleScreen<?, ?> module = this.getModuleForSlot(slotIn.f_40219_);
        if (module != null) {
            Slot slot = slotIn;
            if (slotIn instanceof WrapperSlot) {
                slot = ((WrapperSlot)slotIn).parent;
            }
            if (!module.shouldDrawSlot(slot)) {
                return false;
            }
        }
        return super.m_97774_(slotIn, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        ModuleScreen<?, ?> module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return false;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLastClick, double unkowwn) {
        ModuleScreen<?, ?> module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return false;
        }
        return super.m_7979_(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, unkowwn);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        ModuleScreen<?, ?> module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseScrolled(mouseX, mouseY, delta)) {
            return false;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        ModuleScreen<?, ?> module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseReleased(mouseX, mouseY, state)) {
            return false;
        }
        return super.m_6348_(mouseX, mouseY, state);
    }

    @Nullable
    protected ModuleScreen<?, ?> getModuleForPoint(double x, double y) {
        for (ModuleScreen<?, ?> module : this.modules) {
            if (!this.m_6774_(module.f_97735_, module.f_97736_, module.guiRight(), module.guiBottom(), x + (double)this.cornerX, y + (double)this.cornerY)) continue;
            return module;
        }
        return null;
    }

    @Nullable
    protected ModuleScreen<?, ?> getModuleForSlot(int slotNumber) {
        return this.getModuleForContainer(((MultiModuleContainerMenu)((Object)this.getMenu())).getSlotContainer(slotNumber));
    }

    @Nullable
    protected ModuleScreen<?, ?> getModuleForContainer(AbstractContainerMenu container) {
        for (ModuleScreen<?, ?> module : this.modules) {
            if (module.m_6262_() != container) continue;
            return module;
        }
        return null;
    }

    public CONTAINER getMenu() {
        return (CONTAINER)((Object)((MultiModuleContainerMenu)this.f_97732_));
    }
}

