/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.datamap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.mantle.util.typed.TypedMapBuilder;

public class RegistryDataMapLoader<R, D>
extends SimpleJsonResourceReloadListener {
    public static final BiConsumer<JsonObject, JsonObject> COPY_PARENT_DATA = (json, parentJson) -> {
        for (Map.Entry entry : parentJson.entrySet()) {
            String key = (String)entry.getKey();
            if (json.has(key)) continue;
            json.add(key, (JsonElement)entry.getValue());
        }
    };
    private final String name;
    private final String folder;
    private final Registry<R> registry;
    private final RecordLoadable<D> dataLoader;
    private final BiConsumer<JsonObject, JsonObject> merger;
    private Map<R, D> dataMap = Map.of();

    public RegistryDataMapLoader(String name, String folder, Registry<R> registry, RecordLoadable<D> dataLoader) {
        this(name, folder, registry, dataLoader, COPY_PARENT_DATA);
    }

    public RegistryDataMapLoader(String name, String folder, Registry<R> registry, RecordLoadable<D> dataLoader, BiConsumer<JsonObject, JsonObject> merger) {
        super(JsonHelper.DEFAULT_GSON, folder);
        this.name = name;
        this.registry = registry;
        this.dataLoader = dataLoader;
        this.folder = folder;
        this.merger = merger;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        long time = System.nanoTime();
        HashMap<R, D> dataMap = new HashMap<R, D>();
        HashMap locationMap = new HashMap();
        for (Map.Entry entry : this.registry.m_6579_()) {
            ResourceLocation location = ((ResourceKey)entry.getKey()).m_135782_();
            JsonElement element = jsons.get(location);
            if (element == null) continue;
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)location.toString());
                if (json.keySet().isEmpty()) continue;
                TypedMap context = TypedMapBuilder.builder().put(ContextKey.DEBUG, this.name + " " + location).build();
                dataMap.put(entry.getValue(), RegistryDataMapLoader.parseData(this.name, jsons, location, json, locationMap, this.dataLoader, context, this.merger));
            }
            catch (Exception e) {
                Mantle.logger.error("Failed to parse {} data for {}", (Object)this.name, (Object)location, (Object)e);
            }
        }
        this.dataMap = dataMap;
        Mantle.logger.info("Finished loading {} {} in {} ms", (Object)dataMap.size(), (Object)this.name, (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    public static <D> D parseData(String name, Map<ResourceLocation, JsonElement> jsons, ResourceLocation location, JsonObject json, @Nullable Map<ResourceLocation, D> locationMap, RecordLoadable<D> dataLoader, TypedMap context) {
        return RegistryDataMapLoader.parseData(name, jsons, location, json, locationMap, dataLoader, context, COPY_PARENT_DATA);
    }

    public static <D> D parseData(String name, Map<ResourceLocation, JsonElement> jsons, ResourceLocation location, JsonObject json, @Nullable Map<ResourceLocation, D> locationMap, RecordLoadable<D> dataLoader, TypedMap context, BiConsumer<JsonObject, JsonObject> merger) {
        D parsed;
        JsonFile resolved = RegistryDataMapLoader.processParents(name, jsons, new ArrayList<ResourceLocation>(), location, json, merger);
        if (locationMap != null) {
            parsed = locationMap.get(resolved.location);
            if (parsed == null) {
                parsed = dataLoader.deserialize(resolved.json, context);
                locationMap.put(resolved.location, parsed);
            }
        } else {
            parsed = dataLoader.deserialize(resolved.json, context);
        }
        return parsed;
    }

    public static JsonObject fetchParent(String name, Map<ResourceLocation, JsonElement> jsons, ResourceLocation parentLocation, ResourceLocation location, @Nullable List<ResourceLocation> loadingStack) {
        JsonElement element;
        if (loadingStack != null) {
            loadingStack.add(location);
            if (loadingStack.contains(parentLocation)) {
                throw new JsonSyntaxException("Caught circular dependency trying to resolve " + name + " parent for " + location + ", ignoring parent. Full stack " + loadingStack);
            }
        }
        if ((element = jsons.get(parentLocation)) == null) {
            throw new JsonSyntaxException("Missing parent at " + parentLocation + " for " + name + ", used in " + location);
        }
        return GsonHelper.m_13918_((JsonElement)element, (String)parentLocation.toString());
    }

    private static JsonFile processParents(String name, Map<ResourceLocation, JsonElement> jsons, List<ResourceLocation> loadingStack, ResourceLocation location, JsonObject json, BiConsumer<JsonObject, JsonObject> merger) {
        while (json.has("parent")) {
            ResourceLocation parentLocation = JsonHelper.getResourceLocation(json, "parent");
            JsonObject parentJson = RegistryDataMapLoader.fetchParent(name, jsons, parentLocation, location, loadingStack);
            if (json.keySet().size() == 1) {
                json = parentJson;
                location = parentLocation;
                continue;
            }
            parentJson = RegistryDataMapLoader.processParents((String)name, jsons, loadingStack, (ResourceLocation)parentLocation, (JsonObject)parentJson, merger).json;
            merger.accept(json, parentJson);
            json.remove("parent");
            break;
        }
        return new JsonFile(location, json);
    }

    @Nullable
    public D get(R object) {
        return this.dataMap.get(object);
    }

    public D get(R object, D defaultValue) {
        return this.dataMap.getOrDefault(object, defaultValue);
    }

    public String getFolder() {
        return this.folder;
    }

    public Registry<R> getRegistry() {
        return this.registry;
    }

    public RecordLoadable<D> getDataLoader() {
        return this.dataLoader;
    }

    private record JsonFile(ResourceLocation location, JsonObject json) {
    }
}

