/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable;

import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.function.Consumer;
import slimeknights.mantle.data.loadable.field.ConstantField;
import slimeknights.mantle.data.loadable.field.RecordField;

public interface ErrorFactory
extends Consumer<String> {
    public static final ErrorFactory JSON_SYNTAX_ERROR = JsonSyntaxException::new;
    public static final ErrorFactory DECODER_EXCEPTION = DecoderException::new;
    public static final ErrorFactory ENCODER_EXCEPTION = EncoderException::new;
    public static final ErrorFactory RUNTIME = new ErrorFactory(){

        @Override
        public RuntimeException create(String error) {
            return new RuntimeException(error);
        }

        @Override
        public RuntimeException create(RuntimeException base) {
            return base;
        }
    };
    public static final RecordField<ErrorFactory, Object> FIELD = new ConstantField<ErrorFactory>(JSON_SYNTAX_ERROR, DECODER_EXCEPTION);

    @Override
    default public void accept(String error) {
        throw this.create(error);
    }

    public RuntimeException create(String var1);

    default public RuntimeException create(RuntimeException base) {
        return this.create(base.getMessage());
    }
}

