/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.data.loadable.field.DefaultingField;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.util.typed.TypedMap;

public record LongArrayLoadable(Loadable<Long> base, int minSize, int maxSize) implements ArrayLoadable.SizeRange<long[]>
{
    @Override
    public int getLength(long[] array) {
        return array.length;
    }

    @Override
    public long[] convertCompact(JsonElement element, String key, TypedMap context) {
        return new long[]{this.base.convert(element, key, context)};
    }

    @Override
    public long[] convertArray(JsonArray array, String key, TypedMap context) {
        long[] result = new long[array.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.base.convert(array.get(i), key + "[" + i + "]", context);
        }
        return result;
    }

    @Override
    public JsonElement serializeFirst(long[] object) {
        return this.base.serialize(object[0]);
    }

    @Override
    public void serializeAll(JsonArray array, long[] object) {
        for (long element : object) {
            array.add(this.base.serialize(element));
        }
    }

    @Override
    public long[] decode(FriendlyByteBuf buffer, TypedMap context) {
        int max = buffer.m_130242_();
        long[] array = new long[max];
        for (int i = 0; i < max; ++i) {
            array[i] = (Long)this.base.decode(buffer, context);
        }
        return array;
    }

    @Override
    public void encode(FriendlyByteBuf buffer, long[] array) {
        buffer.m_130130_(array.length);
        for (long element : array) {
            this.base.encode(buffer, element);
        }
    }

    @Override
    public <P> LoadableField<long[], P> defaultField(String key, long[] defaultValue, boolean serializeDefault, Function<P, long[]> getter) {
        return new DefaultingField<long[], P>(this, key, defaultValue, serializeDefault ? null : Arrays::equals, getter);
    }

    @Override
    public <P> LoadableField<long[], P> emptyField(String key, boolean serializeEmpty, Function<P, long[]> getter) {
        return this.defaultField(key, new long[0], serializeEmpty, getter);
    }
}

