/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.field;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.mantle.data.loadable.field.ContextField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.util.typed.TypedMap;

public class ContextKey<T>
implements TypedMap.Key<T> {
    public static final ContextKey<ResourceLocation> ID = new ContextKey("id");
    public static final ContextKey<String> DEBUG = new ContextKey("debug info");
    private final String name;
    private RecordField<T, Object> requiredField;
    private RecordField<T, Object> nullableField;

    public String toString() {
        return "ContextKey('" + this.name + "')'";
    }

    public RecordField<T, Object> requiredField() {
        if (this.requiredField == null) {
            this.requiredField = new Required<Object, Object>(this, (t, e) -> t);
        }
        return this.requiredField;
    }

    public <M> RecordField<M, Object> mappedField(BiFunction<T, ErrorFactory, M> mapper) {
        return new Required<T, M>(this, mapper);
    }

    public RecordField<T, Object> nullableField() {
        if (this.nullableField == null) {
            this.nullableField = new Defaulting<Object>(this, null);
        }
        return this.nullableField;
    }

    public RecordField<T, Object> defaultField(T defaultValue) {
        return new Defaulting<T>(this, defaultValue);
    }

    public ContextKey(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private record Required<T, M>(ContextKey<T> key, BiFunction<T, ErrorFactory, M> mapper) implements ContextField<M>
    {
        @Override
        public M get(TypedMap context, ErrorFactory error) {
            T value = context.get(this.key);
            if (value != null) {
                return this.mapper.apply(value, error);
            }
            throw error.create("Unable to fetch " + this.key.name + " from context, this usually implements a broken JSON deserializer");
        }
    }

    private record Defaulting<T>(ContextKey<T> key, @Nullable T defaultValue) implements ContextField<T>
    {
        @Override
        public T get(TypedMap context, ErrorFactory error) {
            if (this.defaultValue == null) {
                return context.get(this.key);
            }
            return context.getOrDefault(this.key, this.defaultValue);
        }
    }
}

