/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.mapping;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.mapping.MapLoadable;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;

public class EnumMapLoadable<K extends Enum<K>, V>
extends MapLoadable<K, V> {
    private final Class<K> enumClass;

    public EnumMapLoadable(Class<K> enumClass, StringLoadable<K> keyLoadable, Loadable<V> valueLoadable, int minSize) {
        super(keyLoadable, valueLoadable, minSize);
        this.enumClass = enumClass;
    }

    public EnumMapLoadable(EnumLoadable<K> keyLoadable, Loadable<V> valueLoadable, int minSize) {
        this(keyLoadable.enumClass(), keyLoadable, valueLoadable, minSize);
    }

    @Override
    protected Map<K, V> createBuilder(int size) {
        return new EnumMap(this.enumClass);
    }

    @Override
    protected Map<K, V> build(Map<K, V> builder) {
        return Collections.unmodifiableMap(builder);
    }
}

