/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.field.DefaultingField;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.mantle.util.typed.TypedMap;

public class DefaultingLoaderRegistry<T extends GenericLoaderRegistry.IHaveLoader>
extends GenericLoaderRegistry<T> {
    private final T defaultInstance;

    public DefaultingLoaderRegistry(String name, T defaultInstance, boolean compact) {
        super(name, compact);
        this.defaultInstance = defaultInstance;
    }

    public T getDefault() {
        return this.defaultInstance;
    }

    @Override
    public T convert(JsonElement element, String key, TypedMap context) {
        if (element.isJsonNull()) {
            return this.defaultInstance;
        }
        return (T)super.convert(element, key, context);
    }

    @Override
    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == this.defaultInstance) {
            return JsonNull.INSTANCE;
        }
        return this.serialize(src);
    }

    @Override
    public T getOrDefault(JsonObject parent, String key, TypedMap context) {
        return (T)((GenericLoaderRegistry.IHaveLoader)super.getOrDefault(parent, key, this.defaultInstance, context));
    }

    public T getOrDefault(JsonObject parent, String key) {
        return this.getOrDefault(parent, key, TypedMap.EMPTY);
    }

    @Override
    public void encode(FriendlyByteBuf buffer, T src) {
        if (src == this.defaultInstance) {
            this.loaders.encodeOptional(buffer, null);
            return;
        }
        RecordLoadable<? extends GenericLoaderRegistry.IHaveLoader> loader = src.getLoader();
        this.loaders.encodeOptional(buffer, loader);
        this.encode(loader, buffer, src);
    }

    @Override
    public T decode(FriendlyByteBuf buffer, TypedMap context) {
        RecordLoadable loader = (RecordLoadable)this.loaders.decodeOptional(buffer);
        if (loader == null) {
            return this.defaultInstance;
        }
        return (T)((GenericLoaderRegistry.IHaveLoader)loader.decode(buffer, context));
    }

    @Override
    public <P> LoadableField<T, P> defaultField(String key, boolean serializeDefault, Function<P, T> getter) {
        return new DefaultingField<T, P>(this, key, this.defaultInstance, serializeDefault, getter);
    }

    public <P> LoadableField<T, P> defaultField(String key, Function<P, T> getter) {
        return this.defaultField(key, false, getter);
    }
}

