/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.book.BookScreenOpener;
import slimeknights.mantle.datagen.MantleTags;
import slimeknights.mantle.item.LecternBookItem;
import slimeknights.mantle.util.RegistryHelper;

public abstract class AbstractBookItem
extends LecternBookItem {
    private static final Component CLICK_TO_OPEN = Mantle.makeComponent("item", "book.click_to_open").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC});

    public AbstractBookItem(Item.Properties properties) {
        super(properties);
    }

    public abstract BookScreenOpener getBook(ItemStack var1);

    public static boolean isValidContainer(AbstractContainerMenu menu) {
        if (menu.f_38843_ == null) {
            return true;
        }
        try {
            return RegistryHelper.contains(BuiltInRegistries.f_256818_, MantleTags.MenuTypes.REPLACEABLE, menu.m_6772_());
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        Player player;
        if (world != null && world.f_46443_ && (player = SafeClientAccess.getPlayer()) != null && AbstractBookItem.isValidContainer(player.f_36096_)) {
            Inventory inventory = player.m_150109_();
            if (inventory.f_35974_.contains((Object)stack) || inventory.f_35976_.contains((Object)stack)) {
                tooltip.add(CLICK_TO_OPEN);
            }
        }
        super.m_7373_(stack, world, tooltip, flag);
    }

    public void openScreen(Player player, InteractionHand hand, ItemStack stack) {
        this.getBook(stack).openGui(hand, stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            this.openScreen(player, hand, stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void openScreen(Player player, int slotIndex, ItemStack stack) {
        this.getBook(stack).openGui(slotIndex, stack);
    }

    public boolean m_142305_(ItemStack stack, ItemStack held, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && held.m_41619_() && slot.f_40218_ == player.m_150109_() && slot.m_150651_(player) && AbstractBookItem.isValidContainer(player.f_36096_)) {
            if (player.m_9236_().f_46443_) {
                player.f_36096_.m_150444_();
                player.m_6915_();
                this.openScreen(player, slot.getSlotIndex(), stack);
            }
            return true;
        }
        return false;
    }

    @Override
    public void openLecternScreenClient(BlockPos pos, ItemStack book) {
        this.getBook(book).openGui(pos, book);
    }
}

