/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.deferred;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.deferred.DeferredRegisterWrapper;
import slimeknights.mantle.registration.deferred.SynchronizedDeferredRegister;
import slimeknights.mantle.registration.object.EntityObject;

public class EntityTypeDeferredRegister
extends DeferredRegisterWrapper<EntityType<?>> {
    private final SynchronizedDeferredRegister<Item> itemRegistry;

    public EntityTypeDeferredRegister(String modID) {
        super(Registries.f_256939_, modID);
        this.itemRegistry = SynchronizedDeferredRegister.create(Registries.f_256913_, modID);
    }

    @Override
    public void register(IEventBus bus) {
        super.register(bus);
        this.itemRegistry.register(bus);
    }

    public <T extends Entity> RegistryObject<EntityType<T>> register(String name, Supplier<EntityType.Builder<T>> sup) {
        return this.register.register(name, () -> ((EntityType.Builder)sup.get()).m_20712_(this.resourceName(name)));
    }

    public <T extends Mob> EntityObject<T> registerWithEgg(String name, Supplier<EntityType.Builder<T>> sup, int primary, int secondary) {
        RegistryObject object = this.register(name, sup);
        return new EntityObject<T>(object, (Supplier<SpawnEggItem>)this.itemRegistry.register(name + "_spawn_egg", () -> new ForgeSpawnEggItem((Supplier)object, primary, secondary, new Item.Properties())));
    }
}

