/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blockentity;

import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.StorageAccessWrapper;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.items.upgrades.CraftingUpgradeItem;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class BackpackBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    private BackpackWrapper wrapper = BackpackWrapper.DUMMY;
    private boolean isSleepingBagDeployed = false;
    public List<Integer> infiniteAccessUsers = new ArrayList<Integer>();
    public int settingsUser = -1;
    public Component customName = null;
    @Nullable
    public Player player;
    public static final String BACKPACK = "Backpack";
    public static final String SLEEPING_BAG = "SleepingBag";
    public static final String SETTINGS_USER = "SettingsUser";
    public static final String CUSTOM_NAME = "CustomName";
    private static final String TIER = "Tier";
    private static final String INVENTORY = "Inventory";
    private static final String TOOLS_INVENTORY = "ToolsInventory";
    private static final String LEFT_TANK = "LeftTank";
    private static final String RIGHT_TANK = "RightTank";
    private final LazyOptional<IItemHandlerModifiable> inventoryCapability = LazyOptional.of(() -> new StorageAccessWrapper(this.getWrapper(), this.getWrapper().getStorage()));
    private final LazyOptional<IFluidHandler> leftFluidTankCapability = LazyOptional.of(() -> this.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).get().getLeftTank());
    private final LazyOptional<IFluidHandler> rightFluidTankCapability = LazyOptional.of(() -> this.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).get().getRightTank());
    public static ModelProperty<RenderInfo> RENDER_INFO = new ModelProperty();
    public static ModelProperty<Integer> DYE_COLOR = new ModelProperty();
    public static ModelProperty<Boolean> SLEEPING_BAG_DEPLOYED = new ModelProperty();
    public static ModelProperty<Integer> SLEEPING_BAG_COLOR = new ModelProperty();

    public BackpackBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.BACKPACK.get(), pos, state);
    }

    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.writeBackpack(compound);
        compound.m_128379_(SLEEPING_BAG, this.isSleepingBagDeployed);
        if (this.customName != null) {
            compound.m_128359_(CUSTOM_NAME, Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.setBackpackFromNbt(compound);
        if (compound.m_128441_(TIER)) {
            this.setBackpack(this.getOldDataBackpack(compound));
            compound.m_128473_(TIER);
        }
        this.isSleepingBagDeployed = compound.m_128471_(SLEEPING_BAG);
        if (compound.m_128441_(SETTINGS_USER)) {
            this.settingsUser = compound.m_128451_(SETTINGS_USER);
        }
        if (compound.m_128425_(CUSTOM_NAME, 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_(CUSTOM_NAME));
        }
        this.requestModelDataUpdate();
    }

    public void setBackpack(ItemStack backpack) {
        if (backpack.m_41720_() instanceof TravelersBackpackItem) {
            if (this.wrapper == BackpackWrapper.DUMMY) {
                this.wrapper = new BackpackWrapper(backpack.m_41777_(), 3, null, this.m_58904_());
                this.wrapper.setBackpackPos(this.m_58899_());
                this.wrapper.saveHandler = () -> {
                    this.m_6596_();
                    this.notifyBlockUpdate();
                    this.requestModelDataUpdate();
                };
                this.wrapper.abilityHandler = () -> {
                    if (this.m_58904_() != null) {
                        this.m_58904_().m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
                        if (this.m_58900_().m_60734_() == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
                            ((TravelersBackpackBlock)this.m_58900_().m_60734_()).tryAbsorbWater(this.m_58904_(), this.m_58899_());
                        }
                    }
                };
            } else {
                this.wrapper.setBackpackStack(backpack.m_41777_());
            }
        }
    }

    private void setBackpackFromNbt(CompoundTag nbt) {
        this.setBackpack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_(BACKPACK)));
    }

    private void writeBackpack(CompoundTag ret) {
        ItemStack backpackCopy = this.wrapper.getBackpackStack().m_41777_();
        if (backpackCopy.m_41720_() instanceof TravelersBackpackItem) {
            ret.m_128365_(BACKPACK, (Tag)backpackCopy.m_41739_(new CompoundTag()));
        }
    }

    public void removeWrapper() {
        this.wrapper = BackpackWrapper.DUMMY;
    }

    public Direction getBlockDirection() {
        if (this.f_58857_ == null || !(this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof TravelersBackpackBlock) || !this.f_58857_.m_8055_(this.m_58899_()).m_61138_((Property)TravelersBackpackBlock.FACING)) {
            return Direction.NORTH;
        }
        return (Direction)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)TravelersBackpackBlock.FACING);
    }

    public boolean isSleepingBagDeployed() {
        return this.isSleepingBagDeployed;
    }

    public void setSleepingBagDeployed(boolean isSleepingBagDeployed) {
        this.isSleepingBagDeployed = isSleepingBagDeployed;
        this.m_6596_();
        this.notifyBlockUpdate();
    }

    public static boolean canPlaceSleepingBag(BlockPos relative, Level level) {
        return level.m_8055_(relative).m_247087_() && level.m_6857_().m_61937_(relative);
    }

    public boolean deploySleepingBag(Level level, BlockPos pos) {
        Direction direction = this.getBlockDirection();
        this.isThereSleepingBag(direction);
        if (!this.isSleepingBagDeployed()) {
            BlockPos sleepingBagPos1 = pos.m_121945_(direction);
            BlockPos sleepingBagPos2 = sleepingBagPos1.m_121945_(direction);
            if (BackpackBlockEntity.canPlaceSleepingBag(sleepingBagPos1, level) && BackpackBlockEntity.canPlaceSleepingBag(sleepingBagPos2, level)) {
                if (level.m_8055_(sleepingBagPos1.m_7495_()).m_60795_() || level.m_8055_(sleepingBagPos1.m_7495_()).m_60734_() instanceof LiquidBlock) {
                    return false;
                }
                level.m_5594_(null, sleepingBagPos2, SoundEvents.f_12642_, SoundSource.BLOCKS, 0.5f, 1.0f);
                if (!level.f_46443_) {
                    BlockState sleepingBagState = BackpackBlockEntity.getProperSleepingBag(this.getWrapper().getSleepingBagColor());
                    level.m_7731_(sleepingBagPos1, (BlockState)((BlockState)((BlockState)sleepingBagState.m_61124_((Property)SleepingBagBlock.f_54117_, (Comparable)direction)).m_61124_(SleepingBagBlock.PART, (Comparable)BedPart.FOOT)).m_61124_((Property)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                    level.m_7731_(sleepingBagPos2, (BlockState)((BlockState)((BlockState)sleepingBagState.m_61124_((Property)SleepingBagBlock.f_54117_, (Comparable)direction)).m_61124_(SleepingBagBlock.PART, (Comparable)BedPart.HEAD)).m_61124_((Property)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                    level.m_46672_(pos, sleepingBagState.m_60734_());
                    level.m_46672_(sleepingBagPos2, sleepingBagState.m_60734_());
                }
                this.setSleepingBagDeployed(true);
                this.getWrapper().saveHandler.run();
                return true;
            }
        }
        return false;
    }

    public boolean removeSleepingBag(Level level, Direction direction) {
        this.isThereSleepingBag(direction);
        if (this.isSleepingBagDeployed()) {
            BlockPos sleepingBagPos1 = this.m_58899_().m_121945_(direction);
            BlockPos sleepingBagPos2 = sleepingBagPos1.m_121945_(direction);
            if (level.m_8055_(sleepingBagPos1).m_60734_() instanceof SleepingBagBlock && level.m_8055_(sleepingBagPos2).m_60734_() instanceof SleepingBagBlock) {
                level.m_5594_(null, sleepingBagPos2, SoundEvents.f_12642_, SoundSource.BLOCKS, 0.5f, 1.0f);
                level.m_7731_(sleepingBagPos2, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(sleepingBagPos1, Blocks.f_50016_.m_49966_(), 3);
                this.setSleepingBagDeployed(false);
                this.getWrapper().saveHandler.run();
                return true;
            }
        } else {
            this.setSleepingBagDeployed(false);
            this.getWrapper().saveHandler.run();
            return true;
        }
        return false;
    }

    public boolean isThereSleepingBag(Direction direction) {
        if (this.f_58857_.m_8055_(this.m_58899_().m_121945_(direction)).m_60734_() instanceof SleepingBagBlock && this.f_58857_.m_8055_(this.m_58899_().m_121945_(direction).m_121945_(direction)).m_60734_() instanceof SleepingBagBlock) {
            return true;
        }
        this.setSleepingBagDeployed(false);
        return false;
    }

    public static BlockState getProperSleepingBag(int sleepingBagColor) {
        return switch (sleepingBagColor) {
            case 0 -> ((SleepingBagBlock)((Object)ModBlocks.WHITE_SLEEPING_BAG.get())).m_49966_();
            case 1 -> ((SleepingBagBlock)((Object)ModBlocks.ORANGE_SLEEPING_BAG.get())).m_49966_();
            case 2 -> ((SleepingBagBlock)((Object)ModBlocks.MAGENTA_SLEEPING_BAG.get())).m_49966_();
            case 3 -> ((SleepingBagBlock)((Object)ModBlocks.LIGHT_BLUE_SLEEPING_BAG.get())).m_49966_();
            case 4 -> ((SleepingBagBlock)((Object)ModBlocks.YELLOW_SLEEPING_BAG.get())).m_49966_();
            case 5 -> ((SleepingBagBlock)((Object)ModBlocks.LIME_SLEEPING_BAG.get())).m_49966_();
            case 6 -> ((SleepingBagBlock)((Object)ModBlocks.PINK_SLEEPING_BAG.get())).m_49966_();
            case 7 -> ((SleepingBagBlock)((Object)ModBlocks.GRAY_SLEEPING_BAG.get())).m_49966_();
            case 8 -> ((SleepingBagBlock)((Object)ModBlocks.LIGHT_GRAY_SLEEPING_BAG.get())).m_49966_();
            case 9 -> ((SleepingBagBlock)((Object)ModBlocks.CYAN_SLEEPING_BAG.get())).m_49966_();
            case 10 -> ((SleepingBagBlock)((Object)ModBlocks.PURPLE_SLEEPING_BAG.get())).m_49966_();
            case 11 -> ((SleepingBagBlock)((Object)ModBlocks.BLUE_SLEEPING_BAG.get())).m_49966_();
            case 12 -> ((SleepingBagBlock)((Object)ModBlocks.BROWN_SLEEPING_BAG.get())).m_49966_();
            case 13 -> ((SleepingBagBlock)((Object)ModBlocks.GREEN_SLEEPING_BAG.get())).m_49966_();
            case 14 -> ((SleepingBagBlock)((Object)ModBlocks.RED_SLEEPING_BAG.get())).m_49966_();
            case 15 -> ((SleepingBagBlock)((Object)ModBlocks.BLACK_SLEEPING_BAG.get())).m_49966_();
            default -> ((SleepingBagBlock)((Object)ModBlocks.RED_SLEEPING_BAG.get())).m_49966_();
        };
    }

    public ItemStack toItemStack(ItemStack stack) {
        stack.m_41751_(this.wrapper.getBackpackStack().m_41777_().m_41784_());
        return stack;
    }

    private void notifyBlockUpdate() {
        if (this.m_58904_() == null) {
            return;
        }
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58904_().m_8055_(this.m_58899_()), this.m_58904_().m_8055_(this.m_58899_()), 3);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BackpackBlockEntity backpackBlockEntity) {
        BackpackWrapper.tickForBlockEntity(backpackBlockEntity);
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component getDefaultName() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public void setSettingsUser(Player player) {
        this.settingsUser = player.m_19879_();
        this.notifyBlockUpdate();
    }

    public int getSettingsUser() {
        return this.settingsUser;
    }

    public void removeSettingsUser() {
        this.settingsUser = -1;
        this.notifyBlockUpdate();
    }

    public boolean canOpenSettings(Player player) {
        if (!player.m_9236_().f_46443_) {
            return this.settingsUser == player.m_19879_();
        }
        if (this.settingsUser == -1) {
            return true;
        }
        return this.settingsUser == player.m_19879_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = this.m_187482_();
        tag.m_128405_(SETTINGS_USER, this.settingsUser);
        return tag;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        if (this.wrapper == BackpackWrapper.DUMMY) {
            throw new IllegalStateException("BackpackWrapper is not initialized!");
        }
        if (this.canOpenSettings(player)) {
            return new BackpackSettingsMenu(id, inventory, this.wrapper);
        }
        return new BackpackBlockEntityMenu(id, inventory, this.infiniteAccessUsers.contains(player.m_19879_()) ? player.m_19879_() : -1, this.wrapper);
    }

    public static FriendlyByteBuf saveSettingsExtraData(FriendlyByteBuf buf, BlockPos pos) {
        buf.writeBoolean(true);
        buf.m_130064_(pos);
        return buf;
    }

    public void openBackpack(Player player, MenuProvider containerSupplier, BlockPos pos) {
        if (!player.m_9236_().f_46443_) {
            if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.preventMultiplePlayersAccess.get()).booleanValue() && this.getWrapper() != BackpackWrapper.DUMMY && !this.getWrapper().getPlayersUsing().isEmpty()) {
                return;
            }
            if (this.infiniteAccessUsers.contains(player.m_19879_())) {
                this.infiniteAccessUsers.remove((Object)player.m_19879_());
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerSupplier, buf -> {
                buf.writeInt(-1);
                buf.m_130064_(pos);
            });
        }
    }

    public void openBackpackFromCommand(Player player, MenuProvider containerSupplier, BlockPos pos) {
        if (!player.m_9236_().f_46443_) {
            if (!this.infiniteAccessUsers.contains(player.m_19879_())) {
                this.infiniteAccessUsers.add(player.m_19879_());
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerSupplier, buf -> {
                buf.writeInt(player.m_19879_());
                buf.m_130064_(pos);
            });
        }
    }

    public void openSettings(Player player, MenuProvider containerSupplier, BlockPos pos) {
        if (!player.m_9236_().f_46443_) {
            this.setSettingsUser(player);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerSupplier, buf -> BackpackBlockEntity.saveSettingsExtraData(buf, pos));
        }
    }

    public ItemStack getOldDataBackpack(CompoundTag compound) {
        FluidTank tank;
        ItemStack backpack = this.f_58857_ != null ? new ItemStack((ItemLike)this.f_58857_.m_8055_(this.m_58899_()).m_60734_().m_5456_()) : ((TravelersBackpackItem)((Object)ModItems.STANDARD_TRAVELERS_BACKPACK.get())).m_7968_();
        int tier = Tiers.LEATHER.getOrdinal();
        if (compound.m_128441_(TIER)) {
            tier = compound.m_128451_(TIER);
            NbtHelper.set(backpack, TIER, tier);
        }
        BackpackWrapper.initializeSize(backpack);
        int storageSlots = (Integer)NbtHelper.get(backpack, "StorageSlots");
        int toolSlots = (Integer)NbtHelper.get(backpack, "ToolSlots");
        int upgradeSlots = (Integer)NbtHelper.get(backpack, "UpgradeSlots");
        if (compound.m_128441_(INVENTORY)) {
            ItemStackHandler inventory = new ItemStackHandler(99);
            inventory.deserializeNBT(compound.m_128469_(INVENTORY));
            NbtHelper.set(backpack, INVENTORY, inventory);
        }
        if (compound.m_128441_(TOOLS_INVENTORY)) {
            ItemStackHandler tools = new ItemStackHandler(12);
            tools.deserializeNBT(compound.m_128469_(TOOLS_INVENTORY));
            NbtHelper.set(backpack, TOOLS_INVENTORY, tools);
        }
        FluidStack leftFluidStack = FluidStack.EMPTY;
        FluidStack rightFluidStack = FluidStack.EMPTY;
        if (compound.m_128441_(LEFT_TANK)) {
            tank = new FluidTank(20000);
            tank.readFromNBT(compound.m_128469_(LEFT_TANK));
            leftFluidStack = tank.getFluid();
        }
        if (compound.m_128441_(RIGHT_TANK)) {
            tank = new FluidTank(20000);
            tank.readFromNBT(compound.m_128469_(RIGHT_TANK));
            rightFluidStack = tank.getFluid();
        }
        boolean hasCrafting = false;
        ItemStack craftingUpgrade = ((CraftingUpgradeItem)((Object)ModItems.CRAFTING_UPGRADE.get())).m_7968_();
        if (compound.m_128441_("CraftingInventory")) {
            ItemStackHandler craftingInventory = new ItemStackHandler(9);
            craftingInventory.deserializeNBT(compound.m_128469_("CraftingInventory"));
            NbtHelper.set(craftingUpgrade, INVENTORY, craftingInventory);
            hasCrafting = true;
        }
        ItemStack tanksUpgrade = ((TanksUpgradeItem)((Object)ModItems.TANKS_UPGRADE.get())).m_7968_();
        NbtHelper.set(tanksUpgrade, "Fluids", new Fluids(leftFluidStack, rightFluidStack));
        ItemStackHandler upgrades = new ItemStackHandler(upgradeSlots);
        upgrades.setStackInSlot(0, tanksUpgrade);
        if (hasCrafting) {
            upgrades.setStackInSlot(1, craftingUpgrade);
        }
        NbtHelper.set(backpack, "Upgrades", upgrades);
        return backpack;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        Direction direction = this.getBlockDirection();
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.getWrapper() != BackpackWrapper.DUMMY) {
                return this.inventoryCapability.cast();
            }
            return LazyOptional.of(() -> new ItemStackHandler(0)).cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (this.getWrapper() != BackpackWrapper.DUMMY && this.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                if (side == null) {
                    return this.leftFluidTankCapability.cast();
                }
                if (direction == Direction.NORTH) {
                    switch (side) {
                        case WEST: {
                            return this.rightFluidTankCapability.cast();
                        }
                        case EAST: {
                            return this.leftFluidTankCapability.cast();
                        }
                    }
                }
                if (direction == Direction.SOUTH) {
                    switch (side) {
                        case EAST: {
                            return this.rightFluidTankCapability.cast();
                        }
                        case WEST: {
                            return this.leftFluidTankCapability.cast();
                        }
                    }
                }
                if (direction == Direction.EAST) {
                    switch (side) {
                        case NORTH: {
                            return this.rightFluidTankCapability.cast();
                        }
                        case SOUTH: {
                            return this.leftFluidTankCapability.cast();
                        }
                    }
                }
                if (direction == Direction.WEST) {
                    switch (side) {
                        case SOUTH: {
                            return this.rightFluidTankCapability.cast();
                        }
                        case NORTH: {
                            return this.leftFluidTankCapability.cast();
                        }
                    }
                }
                return this.leftFluidTankCapability.cast();
            }
            return LazyOptional.of(() -> new FluidTank(0)).cast();
        }
        return super.getCapability(cap, side);
    }

    public ModelData getModelData() {
        ModelData.Builder modelData = ModelData.builder();
        if (this.getWrapper().isDyed()) {
            modelData.with(DYE_COLOR, (Object)this.getWrapper().getDyeColor());
        }
        modelData.with(RENDER_INFO, (Object)this.getWrapper().getRenderInfo());
        modelData.with(SLEEPING_BAG_DEPLOYED, (Object)this.isSleepingBagDeployed());
        modelData.with(SLEEPING_BAG_COLOR, (Object)this.getWrapper().getSleepingBagColor());
        return modelData.build();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapability.invalidate();
        this.leftFluidTankCapability.invalidate();
        this.rightFluidTankCapability.invalidate();
    }
}

