/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.emi;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.inventory.menu.AbstractBackpackMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.widget.Bounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;

@EmiEntrypoint
public class EmiCompat
implements EmiPlugin {
    public void register(EmiRegistry emiRegistry) {
        emiRegistry.addExclusionArea(BackpackSettingsScreen.class, (screen, consumer) -> screen.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(widget -> {
            int[] size = ((WidgetBase)widget).getWidgetSizeAndPos();
            consumer.accept(new Bounds(size[0], size[1], size[2], size[3]));
        }));
        emiRegistry.addExclusionArea(BackpackScreen.class, (screen, consumer) -> {
            int[] s = screen.settingsWidget.getWidgetSizeAndPos();
            consumer.accept(new Bounds(s[0], s[1], s[2], s[3]));
            screen.m_6702_().stream().filter(w -> w instanceof UpgradeWidgetBase).forEach(widget -> {
                int[] size = ((UpgradeWidgetBase)widget).getWidgetSizeAndPos();
                consumer.accept(new Bounds(size[0], size[1], size[2], size[3]));
            });
            screen.upgradeSlots.forEach(slot -> {
                if (!slot.isHidden()) {
                    int[] size = slot.getUpgradeSlotSizeAndPos();
                    consumer.accept(new Bounds(size[0], size[1], size[2], size[3]));
                }
            });
        });
        emiRegistry.addRecipeHandler((MenuType)ModMenuTypes.BACKPACK_BLOCK_MENU.get(), new GridMenuInfo());
        emiRegistry.addRecipeHandler((MenuType)ModMenuTypes.BACKPACK_MENU.get(), new GridMenuInfo());
    }

    private static class GridMenuInfo<T extends BackpackBaseMenu>
    implements StandardRecipeHandler<T> {
        private GridMenuInfo() {
        }

        @Nullable
        public Slot getOutputSlot(T handler) {
            return handler.m_38853_(((BackpackBaseMenu)((Object)handler)).CRAFTING_RESULT);
        }

        public List<Slot> getInputSources(T handler) {
            int i;
            ArrayList<Slot> list = new ArrayList<Slot>();
            for (i = 0; i < ((BackpackBaseMenu)((Object)handler)).BACKPACK_INV_END; ++i) {
                list.add(handler.m_38853_(i));
            }
            for (i = ((BackpackBaseMenu)((Object)handler)).PLAYER_INV_START; i < ((BackpackBaseMenu)((Object)handler)).PLAYER_HOT_END; ++i) {
                if (((AbstractBackpackMenu)((Object)handler)).getWrapper().getScreenID() == 1 && handler.m_38853_(i) instanceof DisabledSlot) continue;
                list.add(handler.m_38853_(i));
            }
            return list;
        }

        public List<Slot> getCraftingSlots(T handler) {
            ArrayList<Slot> list = new ArrayList<Slot>();
            int firstCraftSlot = ((BackpackBaseMenu)((Object)handler)).CRAFTING_GRID_START;
            for (int i = 0; i < 9; ++i) {
                list.add(handler.m_38853_(firstCraftSlot + i));
            }
            return list;
        }

        public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
            CraftingUpgrade upgrade = ((BackpackBaseMenu)context.getScreenHandler()).getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class).get();
            if (!upgrade.isTabOpened()) {
                ServerboundActionTagPacket.create(0, upgrade.getDataHolderSlot(), true, 0);
            }
            return super.craft(recipe, context);
        }

        public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
            return super.canCraft(recipe, context) && ((BackpackBaseMenu)context.getScreenHandler()).getWrapper().getUpgradeManager().getUpgrade(CraftingUpgrade.class).isPresent();
        }

        public boolean supportsRecipe(EmiRecipe recipe) {
            return VanillaEmiRecipeCategories.CRAFTING.equals(recipe.getCategory()) && recipe.supportsRecipeTree();
        }
    }
}

