/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.mehvahdjukaar.amendments.common.block.WallLanternBlock;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import org.jetbrains.annotations.NotNull;

public class BlockScanner {
    private static final Set<Block> lanterns;
    private static final Set<Block> torches;
    private static final Set<Block> candleHolders;

    @NotNull
    public static Set<Block> getLanterns() {
        return lanterns;
    }

    @NotNull
    public static Set<Block> getTorches() {
        return torches;
    }

    @NotNull
    public static Set<Block> getCandleHolders() {
        return candleHolders;
    }

    static {
        ImmutableSet.Builder lanternBuilder = ImmutableSet.builder();
        ImmutableSet.Builder torchesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder candleBuilder = ImmutableSet.builder();
        for (Block block : BuiltInRegistries.f_256975_) {
            if (WallLanternBlock.isValidBlock(block)) {
                lanternBuilder.add((Object)block);
                continue;
            }
            if (block instanceof TorchBlock && !(block instanceof WallTorchBlock) || CompatHandler.SUPPLEMENTARIES && SuppCompat.isSconce(block)) {
                torchesBuilder.add((Object)block);
                continue;
            }
            if (!CompatHandler.SUPPLEMENTARIES || !SuppCompat.isCandleHolder(block)) continue;
            candleBuilder.add((Object)block);
        }
        torchesBuilder.add((Object)Blocks.f_50174_);
        lanterns = lanternBuilder.build();
        torches = torchesBuilder.build();
        candleHolders = candleBuilder.build();
    }
}

