/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.Map;
import net.mehvahdjukaar.amendments.common.block.CommonCauldronCode;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class ModCauldronBlock
extends AbstractCauldronBlock
implements EntityBlock {
    public static final BooleanProperty BOILING = ModBlockProperties.BOILING;
    private final int maxLevel;

    public ModCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties, Map.of());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BOILING, (Comparable)Boolean.valueOf(false)));
        this.maxLevel = this.getLevelProperty().m_6908_().size();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BOILING});
    }

    public boolean m_142596_(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getLevelProperty()) == this.maxLevel;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        BlockState newState = super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
        return CommonCauldronCode.updateBoilingState(direction, neighborState, level, neighborPos, newState, currentPos);
    }

    public Item m_5456_() {
        return Items.f_42544_;
    }

    public abstract IntegerProperty getLevelProperty();

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)this.getLevelProperty());
    }

    public void m_141997_(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LiquidCauldronBlockTile(pos, state);
    }

    protected double m_142446_(BlockState state) {
        double start = 0.5625;
        double end = 0.9375;
        IntegerProperty levelProperty = this.getLevelProperty();
        int level = (Integer)state.m_61143_((Property)levelProperty);
        if (this.maxLevel <= 1) {
            return start;
        }
        return start + (end - start) * (double)(level - 1) / (double)(this.maxLevel - 1);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (this.m_151979_(state, pos, entity)) {
            CommonCauldronCode.onEntityFallOnContent(level, state, entity, this.m_142446_(state));
            super.m_142072_(level, state, pos, entity, 0.0f);
        } else {
            super.m_142072_(level, state, pos, entity, fallDistance);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (this.m_151979_(state, pos, entity)) {
            CommonCauldronCode.entityInside(state, level, pos, entity, () -> this.m_142446_(state));
            this.handleEntityInsideFluidSpecial(state, level, pos, entity);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        super.m_214162_(state, level, pos, random);
        if (((Boolean)state.m_61143_((Property)BOILING)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            SoftFluidTank tank = te.getSoftFluidTank();
            int color = tank.getCachedParticleColor((BlockAndTintGetter)level, pos);
            int light = tank.getFluidValue().getEmissivity();
            CommonCauldronCode.playBubblingAnimation(level, pos, this.m_142446_(state), random, color, light);
        }
    }

    protected abstract void handleEntityInsideFluidSpecial(BlockState var1, Level var2, BlockPos var3, Entity var4);

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LiquidCauldronBlockTile) {
            SoftFluidStack currentFluid;
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            if (te.handleInteraction(player, hand)) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            SoftFluidTank tank = te.getSoftFluidTank();
            int tankCapacity = tank.getCapacity();
            if (CommonCauldronCode.attemptPlayerCrafting(state, level, pos, player, hand, tankCapacity, currentFluid = tank.getFluid())) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public BlockState updateStateOnFluidChange(BlockState state, Level level, BlockPos pos, SoftFluidStack fluid) {
        int height = fluid.getCount();
        state = fluid.isEmpty() ? Blocks.f_50256_.m_49966_() : (BlockState)state.m_61124_((Property)this.getLevelProperty(), (Comparable)Integer.valueOf(height));
        return state;
    }
}

