/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.List;
import net.mehvahdjukaar.amendments.common.tile.WaterloggedLilyBlockTile;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WaterloggedLilyBlock
extends WaterlilyBlock
implements LiquidBlockContainer,
EntityBlock {
    protected static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape AABB_EXTENDED = Block.m_49796_((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)17.5, (double)15.0);
    protected static final VoxelShape AABB_FAKE = Block.m_49796_((double)1.0, (double)16.0, (double)1.0, (double)15.0, (double)17.5, (double)15.0);
    protected static final VoxelShape AABB_SUPPORT = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final BooleanProperty EXTENDED = BlockStateProperties.f_61432_;

    public WaterloggedLilyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)EXTENDED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{EXTENDED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        return (Boolean)state.m_61143_((Property)EXTENDED) != false ? AABB_FAKE : AABB;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)EXTENDED) != false ? AABB_EXTENDED : AABB;
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
        return AABB_SUPPORT;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public FluidState m_5888_(BlockState state) {
        return Fluids.f_76193_.m_76068_(false);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        return stateIn;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.m_6861_(state, world, pos, neighborBlock, fromPos, moving);
        if (pos.m_7494_().equals((Object)fromPos)) {
            this.maybeConvertToVanilla(state, (LevelAccessor)world, pos);
        }
    }

    public void m_213897_(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        if (!this.maybeConvertToVanilla(state, (LevelAccessor)serverLevel, pos)) {
            // empty if block
        }
        super.m_213897_(state, serverLevel, pos, random);
    }

    private boolean maybeConvertToVanilla(BlockState state, LevelAccessor serverLevel, BlockPos pos) {
        Object object;
        if (serverLevel.m_8055_(pos.m_7494_()).m_60795_() && (object = serverLevel.m_7702_(pos)) instanceof WaterloggedLilyBlockTile) {
            WaterloggedLilyBlockTile te = (WaterloggedLilyBlockTile)((Object)object);
            serverLevel.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
            serverLevel.m_7731_(pos.m_7494_(), te.getHeldBlock(), 3);
            for (Entity e : serverLevel.m_45976_(Entity.class, AABB_SUPPORT.m_83215_().m_82338_(pos).m_82386_(0.0, 0.0625, 0.0))) {
                if (e.m_7752_() == PushReaction.IGNORE) continue;
                e.m_6478_(MoverType.SHULKER_BOX, new Vec3(0.0, 0.09375, 0.0));
            }
            return true;
        }
        if (((Boolean)state.m_61143_((Property)EXTENDED)).booleanValue()) {
            serverLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)EXTENDED, (Comparable)Boolean.valueOf(false)), 3);
        }
        return false;
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public long m_7799_(BlockState pState, BlockPos pPos) {
        return Mth.m_14057_((Vec3i)pPos.m_7494_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WaterloggedLilyBlockTile(pos, state);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        IBlockHolder tile;
        BlockState mimicState;
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)blockEntity).getHeldBlock()).m_60795_() && !(mimicState.m_60734_() instanceof WaterloggedLilyBlock)) {
            return Math.min(super.m_5880_(state, player, worldIn, pos), mimicState.m_60625_(player, worldIn, pos));
        }
        return super.m_5880_(state, player, worldIn, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        IBlockHolder tile;
        BlockState mimicState;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)blockEntity).getHeldBlock()).m_60795_()) {
            return mimicState.m_60827_();
        }
        return super.m_49962_(state);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List drops = super.m_49635_(state, builder);
        Object object = builder.m_287159_(LootContextParams.f_81462_);
        if (object instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)object;
            BlockState heldState = tile.getHeldBlock();
            Object object2 = builder.m_287159_(LootContextParams.f_81455_);
            if (object2 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)object2;
                if (!ForgeHelper.canHarvestBlock((BlockState)heldState, (ServerLevel)builder.m_287258_(), (BlockPos)BlockPos.m_274446_((Position)((Position)builder.m_287261_(LootContextParams.f_81460_))), (ServerPlayer)player)) {
                    return drops;
                }
            }
            List newDrops = heldState.m_287290_(builder);
            drops.addAll(newDrops);
        }
        return drops;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        IBlockHolder tile;
        BlockState mimicState;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof IBlockHolder && !(mimicState = (tile = (IBlockHolder)blockEntity).getHeldBlock()).m_60795_() && !(mimicState.m_60734_() instanceof WaterloggedLilyBlock)) {
            return Math.max(ForgeHelper.getExplosionResistance((BlockState)mimicState, (Level)((Level)world), (BlockPos)pos, (Explosion)explosion), state.m_60734_().m_7325_());
        }
        return 2.0f;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)blockEntity;
            BlockState mimic = tile.getHeldBlock();
            return mimic.m_60734_().m_7397_(level, pos, state);
        }
        return super.m_7397_(level, pos, state);
    }

    public String m_7705_() {
        return Blocks.f_50196_.m_7705_();
    }
}

