/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.entity;

import net.mehvahdjukaar.amendments.client.TumblingAnimation;
import net.mehvahdjukaar.amendments.common.ProjectileStats;
import net.mehvahdjukaar.amendments.common.entity.FireballExplosion;
import net.mehvahdjukaar.amendments.common.entity.IVisualTransformationProvider;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.entity.ParticleTrailEmitter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class MediumFireball
extends ImprovedProjectileEntity
implements IVisualTransformationProvider {
    private final ParticleTrailEmitter trailEmitter = ProjectileStats.makeFireballTrialEmitter();
    private final TumblingAnimation tumblingAnimation = ProjectileStats.makeTumbler();
    private boolean isExtinguished = false;

    public MediumFireball(Level level, LivingEntity shooter) {
        super(ModRegistry.MEDIUM_FIREBALL.get(), shooter, level);
        if (!CommonConfigs.FIRE_CHARGE_GRAVITY.get().booleanValue()) {
            this.m_20242_(true);
        }
    }

    public MediumFireball(Level level, double x, double y, double z) {
        super(ModRegistry.MEDIUM_FIREBALL.get(), x, y, z, level);
        if (!CommonConfigs.FIRE_CHARGE_GRAVITY.get().booleanValue()) {
            this.m_20242_(true);
        }
    }

    public MediumFireball(EntityType<MediumFireball> mediumFireballEntityType, Level level) {
        super(mediumFireballEntityType, level);
        if (!CommonConfigs.FIRE_CHARGE_GRAVITY.get().booleanValue()) {
            this.m_20242_(true);
        }
    }

    public void spawnTrailParticles() {
        super.spawnTrailParticles();
        if (!this.m_9236_().f_46443_) {
            return;
        }
        this.trailEmitter.tick((Projectile)this, (p, v) -> {
            if (this.isExtinguished) {
                return;
            }
            this.m_9236_().m_7106_((ParticleOptions)ModRegistry.FIREBALL_TRAIL_PARTICLE.get(), p.f_82479_, p.f_82480_, p.f_82481_, (double)this.m_20205_(), 0.0, 0.0);
        });
        if (ClientConfigs.CHARGES_TUMBLE.get().booleanValue()) {
            this.tumblingAnimation.tick(this.f_19796_);
        }
    }

    @Override
    public Matrix4f amendments$getVisualTransformation(float partialTicks) {
        return new Matrix4f().rotate((Quaternionfc)this.tumblingAnimation.getRotation(partialTicks));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.isExtinguished && this.m_20069_()) {
            this.isExtinguished = true;
            if (!this.m_9236_().m_5776_()) {
                this.m_20095_();
                this.m_146873_();
                if (this.m_6095_() == EntityType.f_20527_) {
                    this.m_146870_();
                }
            }
        }
        if (!this.isExtinguished) {
            this.m_20254_(1);
        }
    }

    public boolean m_6051_() {
        if (this.m_9236_().f_46443_ && ClientConfigs.FIREBALL_3D.get().booleanValue()) {
            return false;
        }
        return super.m_6051_();
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            if (!this.isExtinguished) {
                boolean bl = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
                FireballExplosion.ExtraSettings settings = new FireballExplosion.ExtraSettings();
                settings.hasKnockback = false;
                settings.soundVolume = ProjectileStats.PLAYER_FIREBALL.soundVolume();
                settings.onFireTicks = ProjectileStats.PLAYER_FIREBALL.indirectHitFireTicks();
                settings.maxDamage = ProjectileStats.PLAYER_FIREBALL.normalExplosionRadius() + 1.0f;
                FireballExplosion.explodeServer(this.m_9236_(), (Entity)this, null, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, bl, Level.ExplosionInteraction.NONE, settings);
            }
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_) {
            Entity entity = result.m_82443_();
            Entity fireballOwner = this.m_19749_();
            if (this.isExtinguished) {
                entity.m_6469_(this.fireballDamage(fireballOwner), ProjectileStats.PLAYER_FIREBALL.damageOnHit());
            } else {
                int fireTick = entity.m_20094_();
                entity.m_20254_(ProjectileStats.PLAYER_FIREBALL.directHitFireTicks());
                if (!entity.m_6469_(this.fireballDamage(fireballOwner), ProjectileStats.PLAYER_FIREBALL.damageOnHit())) {
                    entity.m_7311_(fireTick);
                } else if (fireballOwner instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)fireballOwner;
                    this.m_19970_(le, entity);
                }
            }
        }
    }

    private DamageSource fireballDamage(@Nullable Entity thrower) {
        DamageSources sources = this.m_269291_();
        return thrower == null ? sources.m_269298_(DamageTypes.f_268556_, (Entity)this) : sources.m_268998_(DamageTypes.f_268684_, (Entity)this, thrower);
    }

    protected Item m_7881_() {
        return Items.f_42613_.m_5456_();
    }
}

