/*
 * Decompiled with CFR 0.152.
 */
package mcmk;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import mcmk.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="bettercreeper")
public class BetterCreeperMod {
    public static final String MODID = "bettercreeper";

    public BetterCreeperMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        Config.loadConfig(Config.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("bettercreeper-common.toml"));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        if (explosion.getExploder() instanceof Creeper) {
            Level world;
            if (((Boolean)Config.DISABLE_BLOCK_DAMAGE.get()).booleanValue()) {
                explosion.m_46080_();
            }
            if (((Boolean)Config.DISABLE_ITEM_DAMAGE.get()).booleanValue()) {
                this.removeItemEntities(event.getAffectedEntities());
            }
            if (((Boolean)Config.ENABLE_FLOWER_SPAWN.get()).booleanValue() && !(world = event.getLevel()).m_5776_()) {
                BlockPos blockPos = explosion.getExploder().m_20183_();
                BlockState blockStateDown = world.m_8055_(blockPos.m_7495_());
                BlockState blockState = world.m_8055_(blockPos);
                Block flower = this.getRandomFlowerBlock();
                if (blockState.m_60734_() == Blocks.f_50016_ && (blockStateDown.m_60734_() == Blocks.f_50440_ || blockStateDown.m_60734_() == Blocks.f_50493_ || blockStateDown.m_60734_() == Blocks.f_50546_ || blockStateDown.m_60734_() == Blocks.f_220864_ || blockStateDown.m_60734_() == Blocks.f_220834_)) {
                    BlockPos blockPosition = explosion.getExploder().m_20183_();
                    world.m_46597_(blockPosition, flower.m_49966_());
                } else {
                    explosion.getExploder().m_19998_((ItemLike)flower);
                }
            }
        }
    }

    private Block getRandomFlowerBlock() {
        Random random = new Random();
        Block[] flowers = new Block[]{Blocks.f_50111_, Blocks.f_50112_, Blocks.f_50113_, Blocks.f_50114_, Blocks.f_50115_, Blocks.f_50116_, Blocks.f_50117_, Blocks.f_50119_, Blocks.f_50118_, Blocks.f_50120_, Blocks.f_50121_, Blocks.f_50071_, Blocks.f_50070_, Blocks.f_50356_, Blocks.f_50357_, Blocks.f_50358_};
        return flowers[random.nextInt(flowers.length)];
    }

    private void removeItemEntities(List<Entity> list) {
        Iterator<Entity> iterator = list.iterator();
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (!(entity instanceof ItemEntity)) continue;
            iterator.remove();
        }
    }
}

