/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class TPACommands {
    public static final HashMap<String, TPARequest> REQUESTS = new HashMap();

    public static TPARequest create(FTBEPlayerData source, FTBEPlayerData target, boolean here) {
        String key;
        while (REQUESTS.containsKey(key = String.format("%08X", new Random().nextInt()))) {
        }
        TPARequest r = new TPARequest(key, source, target, here, System.currentTimeMillis());
        REQUESTS.put(key, r);
        return r;
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (FTBEConfig.TPA.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpa").requires((Predicate)FTBEConfig.TPA)).then(Commands.m_82129_((String)"target", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82967_((String[])((CommandSourceStack)ctx.getSource()).m_81377_().m_7641_(), (SuggestionsBuilder)builder)).executes(context -> {
                ServerPlayer source = ((CommandSourceStack)context.getSource()).m_81375_();
                String targetName = StringArgumentType.getString((CommandContext)context, (String)"target");
                ServerPlayer target = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(targetName);
                if (target == null) {
                    source.m_5661_((Component)Component.m_237113_((String)"\u00a7c[TPA] \u73a9\u5bb6\u4e0d\u5b58\u5728\u6216\u672a\u5728\u7ebf!"), false);
                    return 0;
                }
                if (source.m_20148_().equals(target.m_20148_())) {
                    source.m_5661_((Component)Component.m_237113_((String)"\u00a7c[TPA] \u4f60\u4e0d\u80fd\u8bf7\u6c42\u4f20\u9001\u5230\u81ea\u5df1!"), false);
                    return 0;
                }
                return TPACommands.tpa(source, target, false);
            })));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpahere").requires((Predicate)FTBEConfig.TPA)).then(Commands.m_82129_((String)"target", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82967_((String[])((CommandSourceStack)ctx.getSource()).m_81377_().m_7641_(), (SuggestionsBuilder)builder)).executes(context -> {
                ServerPlayer source = ((CommandSourceStack)context.getSource()).m_81375_();
                String targetName = StringArgumentType.getString((CommandContext)context, (String)"target");
                ServerPlayer target = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(targetName);
                if (target == null) {
                    source.m_5661_((Component)Component.m_237113_((String)"\u00a7c[TPA] \u73a9\u5bb6\u4e0d\u5b58\u5728\u6216\u672a\u5728\u7ebf!"), false);
                    return 0;
                }
                if (source.m_20148_().equals(target.m_20148_())) {
                    source.m_5661_((Component)Component.m_237113_((String)"\u00a7c[TPA] \u4f60\u4e0d\u80fd\u8bf7\u6c42\u4f20\u9001\u5230\u81ea\u5df1!"), false);
                    return 0;
                }
                return TPACommands.tpa(source, target, true);
            })));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpaccept").requires((Predicate)FTBEConfig.TPA)).then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).executes(context -> TPACommands.tpaccept(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"id")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpdeny").requires((Predicate)FTBEConfig.TPA)).then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).executes(context -> TPACommands.tpdeny(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"id")))));
        }
    }

    public static int tpa(ServerPlayer player, ServerPlayer target, boolean here) {
        TeleportPos.TeleportResult result;
        FTBEPlayerData dataSource = FTBEPlayerData.getOrCreate((Player)player).orElse(null);
        FTBEPlayerData dataTarget = FTBEPlayerData.getOrCreate((Player)target).orElse(null);
        if (dataSource == null || dataTarget == null) {
            return 0;
        }
        if (REQUESTS.values().stream().anyMatch(r -> r.source == dataSource && r.target == dataTarget)) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c[TPA] \u8bf7\u6c42\u5df2\u53d1\u9001, \u522b\u6025!"), false);
            return 0;
        }
        if (player.equals((Object)target)) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c[TPA] \u4f60\u4e0d\u80fd\u4f20\u9001\u5230\u81ea\u5df1!"), false);
            return 0;
        }
        TeleportPos.TeleportResult teleportResult = result = here ? dataTarget.tpaTeleporter.checkCooldown() : dataSource.tpaTeleporter.checkCooldown();
        if (!result.isSuccess()) {
            return result.runCommand(player);
        }
        TPARequest request = TPACommands.create(dataSource, dataTarget, here);
        MutableComponent component = Component.m_237113_((String)"\u00a7b[TPA] \u00a7f\u60a8\u6536\u5230\u4e86\u4e00\u4e2a\u65b0\u7684\u4f20\u9001\u8bf7\u6c42\n\u00a77\u4f20\u9001\u8bf7\u6c42 [ ");
        component.m_7220_((Component)(here ? target : player).m_5446_().m_6881_().m_130940_(ChatFormatting.YELLOW));
        component.m_7220_((Component)Component.m_237113_((String)" \u00a7f\u27a1 ").m_130940_(ChatFormatting.WHITE));
        component.m_7220_((Component)(here ? player : target).m_5446_().m_6881_().m_130940_(ChatFormatting.YELLOW));
        component.m_7220_((Component)Component.m_237113_((String)"\u00a77 ]"));
        MutableComponent component2 = Component.m_237113_((String)"\u3010");
        component2.m_7220_((Component)Component.m_237113_((String)"\u63a5\u53d7 \u2714").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpaccept " + request.id)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u70b9\u51fb\u4ee5\u63a5\u53d7")))));
        component2.m_7220_((Component)Component.m_237113_((String)" \u00a77| ").m_130940_(ChatFormatting.GRAY));
        component2.m_7220_((Component)Component.m_237113_((String)"\u62d2\u7edd \u274c").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpdeny " + request.id)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u70b9\u51fb\u4ee5\u62d2\u7edd")))));
        component2.m_7220_((Component)Component.m_237113_((String)"\u3011"));
        target.m_5661_((Component)component, false);
        target.m_5661_((Component)component2, false);
        target.m_5661_((Component)Component.m_237113_((String)"\u00a7e\u4f60\u6536\u5230\u4e86\u4e00\u4e2a\u4f20\u9001\u8bf7\u6c42!"), true);
        target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)SoundEvents.f_12216_.m_203334_(), SoundSource.PLAYERS, 1.0f, 1.2f);
        player.m_5661_((Component)Component.m_237113_((String)"\u00a7a[TPA] \u8bf7\u6c42\u5df2\u53d1\u9001!"), false);
        return 1;
    }

    public static int tpaccept(ServerPlayer player, String id) {
        TeleportPos.TeleportResult result;
        TPARequest request = REQUESTS.get(id);
        if (request == null) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7e[TPA] \u65e0\u6548\u8bf7\u6c42!"), false);
            return 0;
        }
        ServerPlayer sourcePlayer = player.f_8924_.m_6846_().m_11259_(request.source.getUuid());
        if (sourcePlayer == null) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7e[TPA] \u76ee\u6807\u73a9\u5bb6\u5df2\u79bb\u7ebf!"), false);
            return 0;
        }
        TeleportPos.TeleportResult teleportResult = result = request.here ? request.target.tpaTeleporter.teleport(player, p -> new TeleportPos((Entity)sourcePlayer)) : request.source.tpaTeleporter.teleport(sourcePlayer, p -> new TeleportPos((Entity)player));
        if (result.isSuccess()) {
            REQUESTS.remove(request.id);
        }
        return result.runCommand(player);
    }

    public static int tpdeny(ServerPlayer player, String id) {
        TPARequest request = REQUESTS.get(id);
        if (request == null) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7e[TPA] \u65e0\u6548\u8bf7\u6c42! "), false);
            return 0;
        }
        REQUESTS.remove(request.id);
        player.m_5661_((Component)Component.m_237113_((String)"\u00a7e[TPA] \u8bf7\u6c42\u88ab\u62d2\u7edd!"), false);
        ServerPlayer player2 = player.f_8924_.m_6846_().m_11259_(request.target.getUuid());
        if (player2 != null) {
            player2.m_5661_((Component)Component.m_237113_((String)"\u00a7e[TPA] \u8bf7\u6c42\u88ab\u62d2\u7edd!"), false);
        }
        return 1;
    }

    public record TPARequest(String id, FTBEPlayerData source, FTBEPlayerData target, boolean here, long created) {
    }
}

