/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.EventResult;
import dev.ftb.mods.ftbessentials.FTBEssentialsEvents;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.BlockUtil;
import dev.ftb.mods.ftbessentials.util.DimensionFilter;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class TeleportCommands {
    public static final TagKey<Block> IGNORE_RTP_BLOCKS = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("ftbessentials", "ignore_rtp"));
    public static final TagKey<Biome> IGNORE_RTP_BIOMES = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("ftbessentials", "ignore_rtp"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (FTBEConfig.BACK.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"back").requires((Predicate)FTBEConfig.BACK)).executes(context -> TeleportCommands.back(((CommandSourceStack)context.getSource()).m_81375_())));
        }
        if (FTBEConfig.SPAWN.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawn").requires((Predicate)FTBEConfig.SPAWN)).executes(context -> TeleportCommands.spawn(((CommandSourceStack)context.getSource()).m_81375_())));
        }
        if (FTBEConfig.RTP.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rtp").requires((Predicate)FTBEConfig.RTP)).executes(context -> TeleportCommands.rtp(((CommandSourceStack)context.getSource()).m_81375_())));
        }
        if (FTBEConfig.TPL.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"teleport_last").requires(FTBEConfig.TPL.enabledAndOp())).then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).executes(context -> TeleportCommands.tpLast(((CommandSourceStack)context.getSource()).m_81375_(), (GameProfile)GameProfileArgument.m_94590_((CommandContext)context, (String)"player").iterator().next()))));
        }
        if (FTBEConfig.TPX.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpx").requires(FTBEConfig.TPX.enabledAndOp())).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> TeleportCommands.tpx(((CommandSourceStack)context.getSource()).m_81375_(), DimensionArgument.m_88808_((CommandContext)context, (String)"dimension")))));
        }
        if (FTBEConfig.JUMP.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"jump").requires(FTBEConfig.JUMP.enabledAndOp())).executes(ctx -> TeleportCommands.jump((CommandSourceStack)ctx.getSource())));
        }
    }

    private static int jump(CommandSourceStack source) {
        try {
            Level level;
            ServerPlayer player = source.m_81375_();
            BlockHitResult res = BlockUtil.getFocusedBlock(player, player.m_20194_().m_6846_().m_11312_() * 16).orElseThrow(() -> new IllegalArgumentException("Not looking at a block"));
            BlockPos.MutableBlockPos mPos = res.m_82425_().m_7494_().m_122032_();
            while (!(TeleportCommands.isEmptyShape(level = player.m_9236_(), mPos.m_7494_()) && TeleportCommands.isEmptyShape(level, mPos.m_6630_(2)) || mPos.m_123342_() >= level.m_151558_())) {
                mPos.m_122175_(Direction.UP, 2);
            }
            Vec3 vec = Vec3.m_82539_((Vec3i)mPos);
            player.m_6021_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Can't jump: " + e.getMessage())));
        }
        return 0;
    }

    private static boolean isEmptyShape(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60812_((BlockGetter)level, pos).m_83281_();
    }

    public static int back(ServerPlayer player) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            if (data.teleportHistory.isEmpty()) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7e[BACK] \u4f20\u9001\u5386\u53f2\u4e3a\u7a7a!").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            if (data.backTeleporter.teleport(player, serverPlayerEntity -> data.teleportHistory.getLast()).runCommand(player) != 0) {
                data.markDirty();
                return 1;
            }
            return 0;
        }).orElse(0);
    }

    public static int spawn(ServerPlayer player) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            ServerLevel level = player.f_8924_.m_129880_(player.m_8963_());
            if (level == null) {
                return 0;
            }
            BlockPos pos = Objects.requireNonNullElse(player.m_8961_(), level.m_220360_());
            return data.spawnTeleporter.teleport(player, p -> new TeleportPos((Level)level, pos, Float.valueOf(player.m_8962_()), Float.valueOf(0.0f))).runCommand(player);
        }).orElse(0);
    }

    public static int rtp(ServerPlayer player) {
        if (!player.m_20310_(2) && !DimensionFilter.isDimensionOK((ResourceKey<Level>)player.m_9236_().m_46472_())) {
            player.m_5661_((Component)Component.m_237113_((String)"You may not use /rtp in this dimension!").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> data.rtpTeleporter.teleport(player, p -> {
            p.m_5661_((Component)Component.m_237113_((String)"Looking for random location..."), false);
            return TeleportCommands.findBlockPos((ServerLevel)player.m_9236_(), p);
        }).runCommand(player)).orElse(0);
    }

    private static TeleportPos findBlockPos(ServerLevel world, ServerPlayer player) {
        for (int attempt = 0; attempt < (Integer)FTBEConfig.RTP_MAX_TRIES.get(); ++attempt) {
            EventResult res;
            double dist = (double)((Integer)FTBEConfig.RTP_MIN_DISTANCE.get()).intValue() + world.f_46441_.m_188500_() * (double)((Integer)FTBEConfig.RTP_MAX_DISTANCE.get() - (Integer)FTBEConfig.RTP_MIN_DISTANCE.get());
            double angle = world.f_46441_.m_188500_() * Math.PI * 2.0;
            int x = Mth.m_14107_((double)(Math.cos(angle) * dist));
            int y = 256;
            int z = Mth.m_14107_((double)(Math.sin(angle) * dist));
            BlockPos currentPos = new BlockPos(x, y, z);
            if (!world.m_6857_().m_61937_(currentPos) || world.m_204166_(currentPos).m_203656_(IGNORE_RTP_BIOMES) || (res = ((FTBEssentialsEvents.RTP)FTBEssentialsEvents.RTP_EVENT.invoker()).teleport(world, player, currentPos, attempt)).isFalse()) continue;
            world.m_46745_(currentPos);
            BlockPos hmPos = world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, currentPos);
            if (hmPos.m_123342_() <= 0) continue;
            BlockPos goodPos = null;
            if (hmPos.m_123342_() < world.m_143344_()) {
                goodPos = hmPos;
            } else {
                for (BlockPos newPos : BlockPos.m_121935_((BlockPos)new BlockPos(hmPos.m_123341_(), world.m_5736_(), hmPos.m_123343_()), (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
                    BlockState bs = world.m_8055_(newPos);
                    if (!bs.m_280555_() || bs.m_204336_(IGNORE_RTP_BLOCKS) || !world.m_46859_(newPos.m_6630_(1)) || !world.m_46859_(newPos.m_6630_(2)) || !world.m_46859_(newPos.m_6630_(3))) continue;
                    goodPos = newPos;
                }
            }
            if (goodPos == null) continue;
            player.m_5661_((Component)Component.m_237113_((String)String.format("Found good location after %d " + (attempt == 1 ? "attempt" : "attempts") + " @ [x %d, z %d]", attempt, goodPos.m_123341_(), goodPos.m_123343_())), false);
            return new TeleportPos((ResourceKey<Level>)world.m_46472_(), goodPos.m_7494_());
        }
        player.m_5661_((Component)Component.m_237113_((String)"Could not find a valid location to teleport to!").m_130940_(ChatFormatting.RED), false);
        return new TeleportPos((Entity)player);
    }

    public static int tpLast(ServerPlayer player, GameProfile to) {
        ServerPlayer toPlayer = player.f_8924_.m_6846_().m_11259_(to.getId());
        if (toPlayer != null) {
            FTBEPlayerData.addTeleportHistory(player);
            new TeleportPos((Entity)toPlayer).teleport(player);
            return 1;
        }
        return FTBEPlayerData.getOrCreate(to).map(dataTo -> {
            FTBEPlayerData.addTeleportHistory(player);
            dataTo.getLastSeenPos().teleport(player);
            return 1;
        }).orElse(0);
    }

    public static int tpx(ServerPlayer player, ServerLevel to) {
        player.m_8999_(to, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
        return 1;
    }
}

