/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.entity.TomeSpawnerBlockEntity;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFSounds;

public class TomeSpawnerBlock
extends BaseEntityBlock {
    public static final IntegerProperty BOOK_STAGES = IntegerProperty.m_61631_((String)"book_stages", (int)1, (int)10);
    public static final BooleanProperty SPAWNER = BooleanProperty.m_61465_((String)"spawner");

    public TomeSpawnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BOOK_STAGES, (Comparable)Integer.valueOf(10))).m_61124_((Property)SPAWNER, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BOOK_STAGES, SPAWNER});
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        BlockEntity blockEntity;
        if (level.m_46791_() != Difficulty.PEACEFUL && ((Boolean)level.m_8055_(pos).m_61143_((Property)SPAWNER)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof TomeSpawnerBlockEntity) {
            TomeSpawnerBlockEntity ts = (TomeSpawnerBlockEntity)blockEntity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < (Integer)state.m_61143_((Property)BOOK_STAGES); ++i) {
                    ts.attemptSpawnTome(serverLevel, pos, true);
                }
                level.m_46961_(pos, false);
            }
        }
        super.onCaughtFire(state, level, pos, face, igniter);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        for (Direction direction : Direction.values()) {
            if (!level.m_8055_(pos.m_121945_(direction)).m_204336_(BlockTags.f_13076_)) continue;
            this.onCaughtFire(state, level, pos, direction, null);
            break;
        }
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity entity, ItemStack stack) {
        if (!level.f_46443_ && ((Boolean)state.m_61143_((Property)SPAWNER)).booleanValue()) {
            level.m_5594_(null, pos, (SoundEvent)TFSounds.DEATH_TOME_DEATH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 20; ++i) {
                double d3 = level.f_46441_.m_188583_() * 0.02;
                double d1 = level.f_46441_.m_188583_() * 0.02;
                double d2 = level.f_46441_.m_188583_() * 0.02;
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 1, d3, d1, d2, (double)0.15f);
            }
        }
        super.m_6240_(level, player, pos, state, entity, stack);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader reader, BlockPos pos) {
        return (float)((Integer)state.m_61143_((Property)BOOK_STAGES)).intValue() * 0.1f;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)SPAWNER) != false ? new TomeSpawnerBlockEntity(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (Boolean)state.m_61143_((Property)SPAWNER) != false ? TomeSpawnerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.TOME_SPAWNER.get()), TomeSpawnerBlockEntity::tick) : null;
    }

    public int getFlammability(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return 30;
    }
}

