/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.block.forcefield;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.ForceFieldBlock;
import twilightforest.client.model.block.forcefield.ForceFieldModelLoader;

public class ForceFieldModel
implements IDynamicBakedModel {
    private static final ModelProperty<ForceFieldData> DATA = new ModelProperty();
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    private final Map<BlockElement, ForceFieldModelLoader.Condition> parts;
    private final Function<Material, TextureAtlasSprite> spriteFunction;
    private final IGeometryBakingContext context;
    private final TextureAtlasSprite particle;
    private final ItemOverrides overrides;
    private final ChunkRenderTypeSet blockRenderTypes;
    private final List<RenderType> itemRenderTypes;
    private final List<RenderType> fabulousItemRenderTypes;

    public ForceFieldModel(Map<BlockElement, ForceFieldModelLoader.Condition> parts, Function<Material, TextureAtlasSprite> spriteFunction, IGeometryBakingContext context, ItemOverrides overrides) {
        this.parts = parts;
        this.spriteFunction = spriteFunction;
        this.context = context;
        this.particle = spriteFunction.apply(context.getMaterial("particle"));
        this.overrides = overrides;
        ResourceLocation renderTypeHint = context.getRenderTypeHint();
        RenderTypeGroup group = renderTypeHint != null ? context.getRenderType(renderTypeHint) : RenderTypeGroup.EMPTY;
        this.blockRenderTypes = !group.isEmpty() ? ChunkRenderTypeSet.of((RenderType[])new RenderType[]{group.block()}) : null;
        this.itemRenderTypes = !group.isEmpty() ? List.of(group.entity()) : null;
        this.fabulousItemRenderTypes = !group.isEmpty() ? List.of(group.entityFabulous()) : null;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction cullFace, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        List<BakedQuad> quads = new ArrayList<BakedQuad>();
        ForceFieldData data = (ForceFieldData)extraData.get(DATA);
        if (data != null) {
            if (cullFace == null) {
                for (Direction direction : Direction.values()) {
                    quads = this.getQuads(quads, direction, data, false);
                }
            } else {
                return this.getQuads(quads, cullFace, data, true);
            }
        }
        return quads;
    }

    @NotNull
    public List<BakedQuad> getQuads(List<BakedQuad> quads, Direction side, ForceFieldData data, boolean cull) {
        for (Map.Entry<BlockElement, ForceFieldModelLoader.Condition> entry : this.parts.entrySet()) {
            BlockElementFace blockelementface = (BlockElementFace)entry.getKey().f_111310_.get(side);
            if (blockelementface == null || blockelementface.f_111354_ != null != cull || ForceFieldModel.skipRender(data.directions(), entry.getValue().direction(), entry.getValue().b(), entry.getValue().parents(), side)) continue;
            TextureAtlasSprite sprite = this.spriteFunction.apply(this.context.getMaterial(blockelementface.f_111356_));
            quads.add(FACE_BAKERY.m_111600_(entry.getKey().f_111308_, entry.getKey().f_111309_, blockelementface, sprite, side, (ModelState)BlockModelRotation.X0_Y0, null, false, new ResourceLocation(sprite.m_247685_().m_135827_(), sprite.m_247685_().m_135815_() + "_" + side.name().toLowerCase(Locale.ROOT))));
        }
        return quads;
    }

    protected static boolean skipRender(Map<ExtraDirection, List<Direction>> directions, @Nullable ExtraDirection direction, boolean supposedToBe, List<ExtraDirection> parents, Direction side) {
        if (direction == null) {
            return false;
        }
        for (ExtraDirection parent : parents) {
            if (directions.containsKey((Object)parent)) continue;
            return true;
        }
        boolean hasKey = directions.containsKey((Object)direction);
        if (hasKey != supposedToBe) {
            return true;
        }
        if (hasKey) {
            return directions.get((Object)direction).contains(side);
        }
        return false;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        if (modelData == ModelData.EMPTY) {
            HashMap<ExtraDirection, List<Direction>> map = new HashMap<ExtraDirection, List<Direction>>();
            for (ExtraDirection extraDirection : ForceFieldModel.getExtraDirections(state, (BlockGetter)level, pos)) {
                ArrayList<Direction> directionList = new ArrayList<Direction>();
                for (Direction dir : Direction.values()) {
                    BlockState other;
                    ExtraDirection mirrored = extraDirection.mirrored(dir.m_122434_());
                    if (mirrored == extraDirection || !((other = level.m_8055_(pos.m_121945_(dir))).m_60734_() instanceof ForceFieldBlock) || !ForceFieldModel.getExtraDirections(other, (BlockGetter)level, pos.m_121945_(dir)).contains((Object)mirrored)) continue;
                    directionList.add(dir);
                }
                map.put(extraDirection, directionList);
            }
            modelData = ModelData.builder().with(DATA, (Object)new ForceFieldData(map)).build();
        }
        return modelData;
    }

    public static List<ExtraDirection> getExtraDirections(BlockState state, BlockGetter level, BlockPos pos) {
        ArrayList<ExtraDirection> directions = new ArrayList<ExtraDirection>();
        boolean down = (Boolean)state.m_61143_((Property)ForceFieldBlock.DOWN);
        boolean up = (Boolean)state.m_61143_((Property)ForceFieldBlock.UP);
        boolean north = (Boolean)state.m_61143_((Property)ForceFieldBlock.NORTH);
        boolean south = (Boolean)state.m_61143_((Property)ForceFieldBlock.SOUTH);
        boolean west = (Boolean)state.m_61143_((Property)ForceFieldBlock.WEST);
        boolean east = (Boolean)state.m_61143_((Property)ForceFieldBlock.EAST);
        if (down) {
            directions.add(ExtraDirection.DOWN);
            if (north && ForceFieldBlock.cornerConnects(level, pos, Direction.DOWN, Direction.NORTH)) {
                directions.add(ExtraDirection.DOWN_NORTH);
            }
            if (south && ForceFieldBlock.cornerConnects(level, pos, Direction.DOWN, Direction.SOUTH)) {
                directions.add(ExtraDirection.DOWN_SOUTH);
            }
            if (west && ForceFieldBlock.cornerConnects(level, pos, Direction.DOWN, Direction.WEST)) {
                directions.add(ExtraDirection.DOWN_WEST);
            }
            if (east && ForceFieldBlock.cornerConnects(level, pos, Direction.DOWN, Direction.EAST)) {
                directions.add(ExtraDirection.DOWN_EAST);
            }
        }
        if (up) {
            directions.add(ExtraDirection.UP);
            if (north && ForceFieldBlock.cornerConnects(level, pos, Direction.UP, Direction.NORTH)) {
                directions.add(ExtraDirection.UP_NORTH);
            }
            if (south && ForceFieldBlock.cornerConnects(level, pos, Direction.UP, Direction.SOUTH)) {
                directions.add(ExtraDirection.UP_SOUTH);
            }
            if (west && ForceFieldBlock.cornerConnects(level, pos, Direction.UP, Direction.WEST)) {
                directions.add(ExtraDirection.UP_WEST);
            }
            if (east && ForceFieldBlock.cornerConnects(level, pos, Direction.UP, Direction.EAST)) {
                directions.add(ExtraDirection.UP_EAST);
            }
        }
        if (north) {
            directions.add(ExtraDirection.NORTH);
            if (west && ForceFieldBlock.cornerConnects(level, pos, Direction.NORTH, Direction.WEST)) {
                directions.add(ExtraDirection.NORTH_WEST);
            }
            if (east && ForceFieldBlock.cornerConnects(level, pos, Direction.NORTH, Direction.EAST)) {
                directions.add(ExtraDirection.NORTH_EAST);
            }
        }
        if (south) {
            directions.add(ExtraDirection.SOUTH);
            if (west && ForceFieldBlock.cornerConnects(level, pos, Direction.SOUTH, Direction.WEST)) {
                directions.add(ExtraDirection.SOUTH_WEST);
            }
            if (east && ForceFieldBlock.cornerConnects(level, pos, Direction.SOUTH, Direction.EAST)) {
                directions.add(ExtraDirection.SOUTH_EAST);
            }
        }
        if (west) {
            directions.add(ExtraDirection.WEST);
        }
        if (east) {
            directions.add(ExtraDirection.EAST);
        }
        return directions;
    }

    public boolean m_7541_() {
        return this.context.useAmbientOcclusion();
    }

    public boolean m_7539_() {
        return this.context.isGui3d();
    }

    public boolean m_7547_() {
        return this.context.useBlockLight();
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particle;
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    @NotNull
    public ItemTransforms m_7442_() {
        return this.context.getTransforms();
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return this.blockRenderTypes != null ? this.blockRenderTypes : super.getRenderTypes(state, rand, data);
    }

    @NotNull
    public List<RenderType> getRenderTypes(@NotNull ItemStack stack, boolean fabulous) {
        if (!fabulous) {
            if (this.itemRenderTypes != null) {
                return this.itemRenderTypes;
            }
        } else if (this.fabulousItemRenderTypes != null) {
            return this.fabulousItemRenderTypes;
        }
        return super.getRenderTypes(stack, fabulous);
    }

    public record ForceFieldData(Map<ExtraDirection, List<Direction>> directions) {
    }

    public static enum ExtraDirection implements StringRepresentable
    {
        DOWN("down", 0, 1, 0),
        UP("up", 1, 0, 1),
        NORTH("north", 2, 2, 3),
        SOUTH("south", 3, 3, 2),
        WEST("west", 5, 4, 4),
        EAST("east", 4, 5, 5),
        DOWN_NORTH("down_north", 6, 10, 7),
        DOWN_SOUTH("down_south", 7, 11, 6),
        DOWN_WEST("down_west", 9, 12, 8),
        DOWN_EAST("down_east", 8, 13, 9),
        UP_NORTH("up_north", 10, 6, 11),
        UP_SOUTH("up_south", 11, 7, 10),
        UP_WEST("up_west", 13, 8, 12),
        UP_EAST("up_east", 12, 9, 13),
        NORTH_WEST("north_west", 15, 14, 16),
        NORTH_EAST("north_east", 14, 15, 17),
        SOUTH_WEST("south_west", 17, 16, 14),
        SOUTH_EAST("south_east", 16, 17, 15);

        public static final StringRepresentable.EnumCodec<ExtraDirection> CODEC;
        private final String name;
        private final int xAxisMirror;
        private final int yAxisMirror;
        private final int zAxisMirror;

        private ExtraDirection(String name, int xAxisMirror, int yAxisMirror, int zAxisMirror) {
            this.name = name;
            this.xAxisMirror = xAxisMirror;
            this.yAxisMirror = yAxisMirror;
            this.zAxisMirror = zAxisMirror;
        }

        public String m_7912_() {
            return this.name;
        }

        public ExtraDirection mirrored(Direction.Axis axis) {
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> ExtraDirection.values()[this.xAxisMirror];
                case Direction.Axis.Y -> ExtraDirection.values()[this.yAxisMirror];
                case Direction.Axis.Z -> ExtraDirection.values()[this.zAxisMirror];
            };
        }

        @Nullable
        public static ExtraDirection byName(@Nullable String name) {
            return (ExtraDirection)CODEC.m_216455_(name);
        }

        static {
            CODEC = StringRepresentable.m_216439_(ExtraDirection::values);
        }
    }
}

