/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.block.entity.FireflyBlockEntity;
import twilightforest.client.BugModelAnimationHelper;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.FireflyModel;

public class FireflyTileEntityRenderer
implements BlockEntityRenderer<FireflyBlockEntity> {
    private final FireflyModel fireflyModel;
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("firefly-tiny.png");

    public FireflyTileEntityRenderer(BlockEntityRendererProvider.Context renderer) {
        this.fireflyModel = new FireflyModel(renderer.m_173582_(TFModelLayers.FIREFLY));
    }

    public void render(@Nullable FireflyBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        int yaw = te != null ? te.currentYaw : BugModelAnimationHelper.currentYaw;
        float glow = te != null ? te.glowIntensity : BugModelAnimationHelper.glowIntensity;
        float randRot = te != null ? te.randRot : 0.0f;
        ms.m_85836_();
        Direction facing = te != null ? (Direction)te.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_) : Direction.NORTH;
        ms.m_252880_(0.5f, 0.5f, 0.5f);
        ms.m_252781_(facing.m_253075_());
        ms.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        ms.m_252781_(Axis.f_252436_.m_252977_(180.0f + randRot));
        ms.m_252781_(Axis.f_252392_.m_252977_((float)yaw));
        ms.m_85836_();
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)textureLoc));
        this.fireflyModel.m_7695_(ms, builder, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        builder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)textureLoc));
        this.fireflyModel.glow.m_104306_(ms, builder, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, glow);
        ms.m_85849_();
        ms.m_85849_();
    }
}

