/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom.stalactites.entry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import twilightforest.TwilightForestMod;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.world.components.feature.BlockSpikeFeature;

public class StalactiteReloadListener
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Stalactite.class, (Object)new Stalactite.Serializer()).create();
    private final Map<ResourceLocation, Stalactite> smallStalactites = new HashMap<ResourceLocation, Stalactite>();
    private final Map<ResourceLocation, Stalactite> mediumStalactites = new HashMap<ResourceLocation, Stalactite>();
    private final Map<ResourceLocation, Stalactite> largeStalactites = new HashMap<ResourceLocation, Stalactite>();

    public StalactiteReloadListener() {
        super(GSON, "stalactites");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        block12: for (Stalactite.HollowHillType type : Stalactite.HollowHillType.values()) {
            ResourceLocation resourcelocation = new ResourceLocation("twilightforest", "stalactites/" + type.name().toLowerCase(Locale.ROOT) + "_hollow_hill.json");
            ArrayList<ResourceLocation> finalLocations = new ArrayList<ResourceLocation>();
            Map<ResourceLocation, Stalactite> mapToUse = type == Stalactite.HollowHillType.LARGE ? this.largeStalactites : (type == Stalactite.HollowHillType.MEDIUM ? this.mediumStalactites : this.smallStalactites);
            for (Resource resource : resourceManager.m_213829_(resourcelocation)) {
                try (InputStream inputstream = resource.m_215507_();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                    JsonObject jsonobject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    boolean replace = jsonobject.get("replace").getAsBoolean();
                    if (replace) {
                        finalLocations.clear();
                    }
                    JsonArray entryList = jsonobject.get("stalactites").getAsJsonArray();
                    for (JsonElement entry : entryList) {
                        ResourceLocation loc = new ResourceLocation(entry.getAsString().replace(":", ":entries/"));
                        finalLocations.remove(loc);
                        finalLocations.add(loc);
                    }
                }
                catch (IOException | RuntimeException ioexception) {
                    TwilightForestMod.LOGGER.error("Couldn't read Hollow Hill list {} in data pack {}", (Object)resourcelocation, (Object)resource.m_215506_(), (Object)ioexception);
                }
                if (finalLocations.isEmpty()) {
                    TwilightForestMod.LOGGER.warn("Hollow Hill list {} was empty, adding default stone entry so things don't break!", (Object)resourcelocation);
                    mapToUse.put(new ResourceLocation("twilightforest", "default_fallback_stone"), BlockSpikeFeature.STONE_STALACTITE);
                    continue block12;
                }
                for (ResourceLocation location : finalLocations) {
                    JsonElement json = object.get(location);
                    mapToUse.put(location, (Stalactite)GSON.fromJson(json, Stalactite.class));
                }
            }
        }
        TwilightForestMod.LOGGER.info("Loaded {} Stalactite configs!", (Object)this.getLargeStalactites().size());
    }

    public static JsonElement serialize(Stalactite stalactite) {
        return GSON.toJsonTree((Object)stalactite);
    }

    public Map<ResourceLocation, Stalactite> getLargeStalactites() {
        Map<ResourceLocation, Stalactite> finalMap = this.largeStalactites;
        finalMap.putAll(this.getMediumStalactites());
        return finalMap;
    }

    public Map<ResourceLocation, Stalactite> getMediumStalactites() {
        Map<ResourceLocation, Stalactite> finalMap = this.mediumStalactites;
        finalMap.putAll(this.getSmallStalactites());
        return finalMap;
    }

    public Map<ResourceLocation, Stalactite> getSmallStalactites() {
        return this.smallStalactites;
    }

    public Stalactite getRandomStalactiteFromList(RandomSource random, Map<ResourceLocation, Stalactite> map) {
        Stalactite[] list = map.values().toArray(new Stalactite[0]);
        return list[random.m_188503_(list.length)];
    }
}

