/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import twilightforest.entity.ai.goal.HoverBaseGoal;
import twilightforest.entity.boss.SnowQueen;

public class HoverSummonGoal
extends HoverBaseGoal<SnowQueen> {
    private static final int MAX_MINIONS_AT_ONCE = 4;
    private int seekTimer;
    private final int maxSeekTime;

    public HoverSummonGoal(SnowQueen snowQueen) {
        super(snowQueen, 6.0f, 6.0f);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.maxSeekTime = 80;
    }

    public boolean m_8036_() {
        LivingEntity target = ((SnowQueen)this.attacker).m_5448_();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (((SnowQueen)this.attacker).getCurrentPhase() != SnowQueen.Phase.SUMMON) {
            return false;
        }
        return ((SnowQueen)this.attacker).m_21574_().m_148306_((Entity)target);
    }

    public boolean m_8045_() {
        LivingEntity target = ((SnowQueen)this.attacker).m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (((SnowQueen)this.attacker).getCurrentPhase() != SnowQueen.Phase.SUMMON) {
            return false;
        }
        if (this.seekTimer > this.maxSeekTime) {
            return false;
        }
        return ((SnowQueen)this.attacker).m_142582_((Entity)target);
    }

    public void m_8041_() {
    }

    public void m_8037_() {
        ++this.seekTimer;
        LivingEntity target = ((SnowQueen)this.attacker).m_5448_();
        if (target != null && ((SnowQueen)this.attacker).m_20275_(this.hoverPosX, this.hoverPosY, this.hoverPosZ) <= 3.0) {
            this.checkAndSummon();
            this.makeNewHoverSpot(target);
        }
        double offsetX = this.hoverPosX - ((SnowQueen)this.attacker).m_20185_();
        double offsetY = this.hoverPosY - ((SnowQueen)this.attacker).m_20186_();
        double offsetZ = this.hoverPosZ - ((SnowQueen)this.attacker).m_20189_();
        double distanceDesired = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        distanceDesired = Mth.m_14116_((float)((float)distanceDesired));
        double velX = offsetX / distanceDesired * 0.05;
        double velY = offsetY / distanceDesired * 0.1;
        double velZ = offsetZ / distanceDesired * 0.05;
        ((SnowQueen)this.attacker).m_5997_(velX, velY += 0.05, velZ);
        if (target != null) {
            ((SnowQueen)this.attacker).m_21391_((Entity)target, 30.0f, 30.0f);
            ((SnowQueen)this.attacker).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
    }

    @Override
    protected void makeNewHoverSpot(LivingEntity target) {
        super.makeNewHoverSpot(target);
        this.seekTimer = 0;
    }

    private void checkAndSummon() {
        if (((SnowQueen)this.attacker).getSummonsRemaining() > 0 && ((SnowQueen)this.attacker).countMyMinions() < 4) {
            ((SnowQueen)this.attacker).summonMinionAt(((SnowQueen)this.attacker).m_5448_());
        }
    }
}

