/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFSounds;
import twilightforest.util.LegacyLandmarkPlacements;

public class HostileWolf
extends Monster {
    public HostileWolf(EntityType<? extends HostileWolf> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new LeapGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{HostileWolf.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_6710_(@Nullable LivingEntity entity) {
        if (entity != null && entity != this.m_5448_()) {
            this.m_5496_(this.getTargetSound(), 4.0f, this.m_6100_());
        }
        super.m_6710_(entity);
    }

    public static boolean checkWolfSpawnRules(EntityType<? extends HostileWolf> entity, ServerLevelAccessor accessor, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return accessor.m_46791_() != Difficulty.PEACEFUL && HostileWolf.isValidLightLevel(accessor, pos, random) && HostileWolf.m_217057_(entity, (LevelAccessor)accessor, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isValidLightLevel(ServerLevelAccessor accessor, BlockPos pos, RandomSource random) {
        int chunkZ;
        int chunkX = Mth.m_14143_((float)pos.m_123341_()) >> 4;
        return LegacyLandmarkPlacements.getNearestLandmark(chunkX, chunkZ = Mth.m_14143_((float)pos.m_123343_()) >> 4, (WorldGenLevel)accessor.m_6018_()) == TFLandmark.HEDGE_MAZE || Monster.m_219009_((ServerLevelAccessor)accessor, (BlockPos)pos, (RandomSource)random);
    }

    protected SoundEvent getTargetSound() {
        return (SoundEvent)TFSounds.HOSTILE_WOLF_TARGET.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.HOSTILE_WOLF_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.HOSTILE_WOLF_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.HOSTILE_WOLF_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected boolean m_8028_() {
        return true;
    }

    public float getTailAngle() {
        if (this.m_5448_() != null) {
            return 1.5393804f;
        }
        return 0.62831855f;
    }

    public static class LeapGoal
    extends LeapAtTargetGoal {
        private final Mob mob;

        public LeapGoal(Mob mob, float jump) {
            super(mob, jump);
            this.mob = mob;
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.m_21561_(false);
        }
    }
}

