/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class DarkCanopyTreeFeature
extends Feature<TreeConfiguration> {
    public DarkCanopyTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfiguration> ctx) {
        final WorldGenLevel reader = ctx.m_159774_();
        BlockPos pos = ctx.m_159777_();
        RandomSource rand = ctx.m_225041_();
        boolean foundDirt = false;
        for (int dy = pos.m_123342_(); dy >= reader.m_141937_(); --dy) {
            BlockState state = reader.m_8055_(new BlockPos(pos.m_123341_(), dy - 1, pos.m_123343_()));
            if (state.m_204336_(BlockTags.f_144274_)) {
                foundDirt = true;
                pos = new BlockPos(pos.m_123341_(), dy, pos.m_123343_());
                break;
            }
            if (state.m_204336_(BlockTags.f_13061_) || state.m_204336_(BlockTags.f_13029_)) break;
        }
        if (!foundDirt) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (TreeFeature.m_67272_((LevelSimulatedReader)reader, (BlockPos)pos.m_5484_(Direction.UP, i))) continue;
            return false;
        }
        for (Direction e : Direction.Plane.HORIZONTAL) {
            if (!reader.m_8055_(pos.m_121945_(e)).m_204336_(BlockTags.f_13106_)) continue;
            return false;
        }
        TreeConfiguration treeconfiguration = (TreeConfiguration)ctx.m_159778_();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        final HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biconsumer = (p_160555_, p_160556_) -> {
            set.add(p_160555_.m_7949_());
            reader.m_7731_(p_160555_, p_160556_, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer1 = (p_160548_, p_160549_) -> {
            set1.add(p_160548_.m_7949_());
            reader.m_7731_(p_160548_, p_160549_, 19);
        };
        FoliagePlacer.FoliageSetter setter = new FoliagePlacer.FoliageSetter(){

            public void m_271838_(BlockPos pos, BlockState state) {
                set2.add(pos.m_7949_());
                reader.m_7731_(pos, state, 19);
            }

            public boolean m_271808_(BlockPos p_272999_) {
                return set2.contains(p_272999_);
            }
        };
        BiConsumer<BlockPos, BlockState> biconsumer3 = (p_225290_, p_225291_) -> {
            set3.add(p_225290_.m_7949_());
            reader.m_7731_(p_225290_, p_225291_, 19);
        };
        boolean flag = this.doPlace(reader, rand, pos, biconsumer, biconsumer1, setter, treeconfiguration);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!treeconfiguration.f_68187_.isEmpty()) {
                TreeDecorator.Context treedecorator$context = new TreeDecorator.Context((LevelSimulatedReader)reader, biconsumer3, rand, (Set)set1, (Set)set2, (Set)set);
                treeconfiguration.f_68187_.forEach(p_225282_ -> p_225282_.m_214187_(treedecorator$context));
            }
            return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)set1, (Iterable)set2, (Iterable)set3)).map(p_160521_ -> {
                DiscreteVoxelShape shape = DarkCanopyTreeFeature.updateLeaves((LevelAccessor)reader, p_160521_, set1, set3);
                StructureTemplate.m_74510_((LevelAccessor)reader, (int)3, (DiscreteVoxelShape)shape, (int)p_160521_.m_162395_(), (int)p_160521_.m_162396_(), (int)p_160521_.m_162398_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private boolean doPlace(WorldGenLevel level, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> consumer, BiConsumer<BlockPos, BlockState> consumer1, FoliagePlacer.FoliageSetter foliageSetter, TreeConfiguration config) {
        int i = config.f_68190_.m_226153_(random);
        int j = config.f_68189_.m_214116_(random, i, config);
        int k = i - j;
        int l = config.f_68189_.m_214117_(random, k);
        BlockPos blockpos = config.f_225455_.map(placer -> placer.m_225891_(pos, random)).orElse(pos);
        int i1 = Math.min(pos.m_123342_(), blockpos.m_123342_());
        int j1 = Math.max(pos.m_123342_(), blockpos.m_123342_()) + i + 1;
        if (i1 >= level.m_141937_() + 1 && j1 <= level.m_151558_()) {
            OptionalInt optionalint = config.f_68191_.m_68295_();
            int k1 = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, i, blockpos, config);
            if (k1 >= i || optionalint.isPresent() && k1 >= optionalint.getAsInt()) {
                if (config.f_225455_.isPresent() && !((RootPlacer)config.f_225455_.get()).m_213684_((LevelSimulatedReader)level, consumer, random, pos, blockpos, config)) {
                    return false;
                }
                List list = config.f_68190_.m_213934_((LevelSimulatedReader)level, consumer1, random, k1, blockpos, config);
                list.forEach(attachment -> config.f_68189_.m_271927_((LevelSimulatedReader)level, foliageSetter, random, config, k1, attachment, j, l));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader level, int trunkHeight, BlockPos pos, TreeConfiguration config) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= trunkHeight + 1; ++i) {
            int j = config.f_68191_.m_6133_(trunkHeight, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    mutable.m_122154_((Vec3i)pos, k, i, l);
                    if (DarkCanopyTreeFeature.validTreePos(level, (BlockPos)mutable) && config.f_68193_) continue;
                    return i - 2;
                }
            }
        }
        return trunkHeight;
    }

    protected void m_5974_(LevelWriter world, BlockPos pos, BlockState state) {
        DarkCanopyTreeFeature.setBlockKnownShape(world, pos, state);
    }

    public static void setBlockKnownShape(LevelWriter p_236408_0_, BlockPos p_236408_1_, BlockState p_236408_2_) {
        p_236408_0_.m_7731_(p_236408_1_, p_236408_2_, 19);
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor p_67203_, BoundingBox p_67204_, Set<BlockPos> p_67205_, Set<BlockPos> p_67206_) {
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(p_67204_.m_71056_(), p_67204_.m_71057_(), p_67204_.m_71058_());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : Lists.newArrayList(p_67206_)) {
            if (!p_67204_.m_71051_((Vec3i)blockpos)) continue;
            discretevoxelshape.m_142703_(blockpos.m_123341_() - p_67204_.m_162395_(), blockpos.m_123342_() - p_67204_.m_162396_(), blockpos.m_123343_() - p_67204_.m_162398_());
        }
        for (BlockPos blockpos1 : Lists.newArrayList(p_67205_)) {
            if (p_67204_.m_71051_((Vec3i)blockpos1)) {
                discretevoxelshape.m_142703_(blockpos1.m_123341_() - p_67204_.m_162395_(), blockpos1.m_123342_() - p_67204_.m_162396_(), blockpos1.m_123343_() - p_67204_.m_162398_());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutableblockpos.m_122159_((Vec3i)blockpos1, direction);
                if (p_67205_.contains(blockpos$mutableblockpos) || !(blockstate = p_67203_.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)list.get(0)).add(blockpos$mutableblockpos.m_7949_());
                DarkCanopyTreeFeature.setBlockKnownShape((LevelWriter)p_67203_, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
                if (!p_67204_.m_71051_((Vec3i)blockpos$mutableblockpos)) continue;
                discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - p_67204_.m_162395_(), blockpos$mutableblockpos.m_123342_() - p_67204_.m_162396_(), blockpos$mutableblockpos.m_123343_() - p_67204_.m_162398_());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (p_67204_.m_71051_((Vec3i)blockpos2)) {
                    discretevoxelshape.m_142703_(blockpos2.m_123341_() - p_67204_.m_162395_(), blockpos2.m_123342_() - p_67204_.m_162396_(), blockpos2.m_123343_() - p_67204_.m_162398_());
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutableblockpos.m_122159_((Vec3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutableblockpos) || set1.contains(blockpos$mutableblockpos) || !(blockstate1 = p_67203_.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_) || (k = ((Integer)blockstate1.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(l + 1));
                    DarkCanopyTreeFeature.setBlockKnownShape((LevelWriter)p_67203_, (BlockPos)blockpos$mutableblockpos, blockstate2);
                    if (p_67204_.m_71051_((Vec3i)blockpos$mutableblockpos)) {
                        discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - p_67204_.m_162395_(), blockpos$mutableblockpos.m_123342_() - p_67204_.m_162396_(), blockpos$mutableblockpos.m_123343_() - p_67204_.m_162398_());
                    }
                    set1.add(blockpos$mutableblockpos.m_7949_());
                }
            }
        }
        return discretevoxelshape;
    }

    public static boolean validTreePos(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_278411_));
    }
}

