/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.trainmap;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.compat.trainmap.TrainMapManager;
import com.simibubi.create.compat.trainmap.TrainMapSyncClient;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import journeymap.client.api.display.Context;
import journeymap.client.api.util.UIState;
import journeymap.client.ui.fullscreen.Fullscreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraftforge.client.event.InputEvent;

public class JourneyTrainMap {
    private static boolean requesting;

    public static void tick() {
        if (!((Boolean)AllConfigs.client().showTrainMapOverlay.get()).booleanValue() || !(Minecraft.m_91087_().f_91080_ instanceof Fullscreen)) {
            if (requesting) {
                TrainMapSyncClient.stopRequesting();
            }
            requesting = false;
            return;
        }
        TrainMapManager.tick();
        requesting = true;
        TrainMapSyncClient.requestData();
    }

    public static void mouseClick(InputEvent.MouseButton.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (!(screen instanceof Fullscreen)) {
            return;
        }
        Fullscreen screen2 = (Fullscreen)screen;
        Window window = mc.m_91268_();
        double mX = mc.f_91067_.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_();
        double mY = mc.f_91067_.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_();
        if (TrainMapManager.handleToggleWidgetClick(Mth.m_14107_((double)mX), Mth.m_14107_((double)mY), 3, 30)) {
            event.setCanceled(true);
        }
    }

    public static void onRender(GuiGraphics graphics, Fullscreen screen, double x, double z, int mX, int mY, float pt) {
        UIState state = screen.getUiState();
        if (state == null) {
            return;
        }
        if (state.ui != Context.UI.Fullscreen) {
            return;
        }
        if (!state.active) {
            return;
        }
        if (!((Boolean)AllConfigs.client().showTrainMapOverlay.get()).booleanValue()) {
            JourneyTrainMap.renderToggleWidgetAndTooltip(graphics, screen, mX, mY);
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        double guiScale = (double)window.m_85443_() / (double)window.m_85445_();
        double scale = state.blockSize / guiScale;
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)screen.f_96543_ / 2.0f, (float)screen.f_96544_ / 2.0f, 0.0f);
        pose.m_85841_((float)scale, (float)scale, 1.0f);
        pose.m_85837_(-x, -z, 0.0);
        float mouseX = (float)mX - (float)screen.f_96543_ / 2.0f;
        float mouseY = (float)mY - (float)screen.f_96544_ / 2.0f;
        mouseX = (float)((double)mouseX / scale);
        mouseY = (float)((double)mouseY / scale);
        mouseX = (float)((double)mouseX + x);
        mouseY = (float)((double)mouseY + z);
        Rect2i bounds = new Rect2i(Mth.m_14107_((double)((double)((float)(-screen.f_96543_) / 2.0f) / scale + x)), Mth.m_14107_((double)((double)((float)(-screen.f_96544_) / 2.0f) / scale + z)), Mth.m_14107_((double)((double)screen.f_96543_ / scale)), Mth.m_14107_((double)((double)screen.f_96544_ / scale)));
        List<FormattedText> tooltip = TrainMapManager.renderAndPick(graphics, Mth.m_14143_((float)mouseX), Mth.m_14143_((float)mouseY), pt, false, bounds);
        pose.m_85849_();
        if (!JourneyTrainMap.renderToggleWidgetAndTooltip(graphics, screen, mX, mY) && tooltip != null) {
            RemovedGuiUtils.drawHoveringText(graphics, tooltip, mX, mY, screen.f_96543_, screen.f_96544_, 256, mc.f_91062_);
        }
    }

    private static boolean renderToggleWidgetAndTooltip(GuiGraphics graphics, Fullscreen screen, int mouseX, int mouseY) {
        TrainMapManager.renderToggleWidget(graphics, 3, 30);
        if (!TrainMapManager.isToggleWidgetHovered(mouseX, mouseY, 3, 30)) {
            return false;
        }
        RemovedGuiUtils.drawHoveringText(graphics, List.of(CreateLang.translate("train_map.toggle", new Object[0]).component()), mouseX, mouseY + 20, screen.f_96543_, screen.f_96544_, 256, Minecraft.m_91087_().f_91062_);
        return true;
    }
}

