/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.sync;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class ContraptionSeatMappingPacket
extends SimplePacketBase {
    private Map<UUID, Integer> mapping;
    private int entityID;
    private int dismountedID;

    public ContraptionSeatMappingPacket(int entityID, Map<UUID, Integer> mapping) {
        this(entityID, mapping, -1);
    }

    public ContraptionSeatMappingPacket(int entityID, Map<UUID, Integer> mapping, int dismountedID) {
        this.entityID = entityID;
        this.mapping = mapping;
        this.dismountedID = dismountedID;
    }

    public ContraptionSeatMappingPacket(FriendlyByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.dismountedID = buffer.readInt();
        this.mapping = new HashMap<UUID, Integer>();
        int size = buffer.readShort();
        for (int i = 0; i < size; ++i) {
            this.mapping.put(buffer.m_130259_(), Integer.valueOf(buffer.readShort()));
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityID);
        buffer.writeInt(this.dismountedID);
        buffer.writeShort(this.mapping.size());
        this.mapping.forEach((k, v) -> {
            buffer.m_130077_(k);
            buffer.writeShort(v.intValue());
        });
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            Entity entityByID = Minecraft.m_91087_().f_91073_.m_6815_(this.entityID);
            if (!(entityByID instanceof AbstractContraptionEntity)) {
                return;
            }
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entityByID;
            if (this.dismountedID != -1) {
                Entity dismountedByID = Minecraft.m_91087_().f_91073_.m_6815_(this.dismountedID);
                if (Minecraft.m_91087_().f_91074_ != dismountedByID) {
                    return;
                }
                Vec3 transformedVector = contraptionEntity.getPassengerPosition(dismountedByID, 1.0f);
                if (transformedVector != null) {
                    dismountedByID.getPersistentData().m_128365_("ContraptionDismountLocation", (Tag)VecHelper.writeNBT((Vec3)transformedVector));
                }
            }
            contraptionEntity.getContraption().setSeatMapping(this.mapping);
        });
        return true;
    }
}

